/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.randomizedtesting;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;

final class Validation {
    Validation() {
    }

    public static MethodValidation checkThat(Method method) {
        return new MethodValidation(method);
    }

    public static ClassValidation checkThat(Class<?> clazz) {
        return new ClassValidation(clazz);
    }

    public static final class ClassValidation {
        private final Class<?> clazz;
        private String description;

        public ClassValidation(Class<?> clazz) {
            this.clazz = clazz;
            this.description = "Class " + clazz.getName();
        }

        public ClassValidation describedAs(String message) {
            this.description = message;
            return this;
        }

        public ClassValidation isPublic() {
            if (!Modifier.isPublic(this.clazz.getModifiers())) {
                throw new RuntimeException(this.description + " should be public.");
            }
            return this;
        }

        public ClassValidation isConcreteClass() {
            if (Modifier.isInterface(this.clazz.getModifiers())) {
                throw new RuntimeException(this.description + " should be a conrete class (not an interface).");
            }
            if (Modifier.isAbstract(this.clazz.getModifiers())) {
                throw new RuntimeException(this.description + " should be a concrete class (not abstract).");
            }
            return this;
        }

        public void hasPublicNoArgsConstructor() {
            try {
                this.clazz.getConstructor(new Class[0]);
            }
            catch (Throwable e) {
                throw new RuntimeException(this.description + " should have a public parameterless constructor.");
            }
        }
    }

    public static final class MethodValidation {
        private final Method m;
        private String description;

        public MethodValidation(Method m) {
            this.m = m;
            this.description = "Method " + m.getName();
        }

        public MethodValidation describedAs(String message) {
            this.description = message;
            return this;
        }

        public MethodValidation isPublic() {
            if (!Modifier.isPublic(this.m.getModifiers())) {
                throw new RuntimeException(this.description + " should be public.");
            }
            return this;
        }

        public MethodValidation hasArgsCount(int argsCount) {
            if (this.m.getParameterTypes().length != argsCount) {
                throw new RuntimeException(this.description + " should have " + argsCount + " parameters and" + " has these: " + Arrays.toString(this.m.getParameterTypes()));
            }
            return this;
        }

        public MethodValidation isStatic() {
            if (!Modifier.isStatic(this.m.getModifiers())) {
                throw new RuntimeException(this.description + " should be static.");
            }
            return this;
        }

        public MethodValidation isNotStatic() {
            if (Modifier.isStatic(this.m.getModifiers())) {
                throw new RuntimeException(this.description + " should be instance method (not static).");
            }
            return this;
        }

        public MethodValidation hasReturnType(Class<?> clazz) {
            if (!clazz.isAssignableFrom(this.m.getReturnType())) {
                throw new RuntimeException(this.description + " should have a return " + "type assignable to: " + clazz.getName());
            }
            return this;
        }
    }
}

