/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.SolrException;

public class NamedList<T>
implements Cloneable,
Serializable,
Iterable<Map.Entry<String, T>> {
    private static final long serialVersionUID = 1957981902839867821L;
    protected final List<Object> nvPairs;

    public NamedList() {
        this.nvPairs = new ArrayList<Object>();
    }

    public NamedList(int sz) {
        this.nvPairs = new ArrayList<Object>(sz << 1);
    }

    public NamedList(Map.Entry<String, ? extends T>[] nameValuePairs) {
        this.nvPairs = this.nameValueMapToList(nameValuePairs);
    }

    public NamedList(Map<String, ? extends T> nameValueMap) {
        if (null == nameValueMap) {
            this.nvPairs = new ArrayList<Object>();
        } else {
            this.nvPairs = new ArrayList<Object>(nameValueMap.size());
            for (Map.Entry<String, T> ent : nameValueMap.entrySet()) {
                this.nvPairs.add(ent.getKey());
                this.nvPairs.add(ent.getValue());
            }
        }
    }

    @Deprecated
    public NamedList(List<Object> nameValuePairs) {
        this.nvPairs = nameValuePairs;
    }

    @Deprecated
    private List<Object> nameValueMapToList(Map.Entry<String, ? extends T>[] nameValuePairs) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Map.Entry<String, T> entry : nameValuePairs) {
            result.add(entry.getKey());
            result.add(entry.getValue());
        }
        return result;
    }

    public int size() {
        return this.nvPairs.size() >> 1;
    }

    public String getName(int idx) {
        return (String)this.nvPairs.get(idx << 1);
    }

    public T getVal(int idx) {
        return (T)this.nvPairs.get((idx << 1) + 1);
    }

    public void add(String name, T val) {
        this.nvPairs.add(name);
        this.nvPairs.add(val);
    }

    public void setName(int idx, String name) {
        this.nvPairs.set(idx << 1, name);
    }

    public T setVal(int idx, T val) {
        int index = (idx << 1) + 1;
        Object old = this.nvPairs.get(index);
        this.nvPairs.set(index, val);
        return (T)old;
    }

    public T remove(int idx) {
        int index = idx << 1;
        this.nvPairs.remove(index);
        Object result = this.nvPairs.remove(index);
        return (T)result;
    }

    public int indexOf(String name, int start) {
        int sz = this.size();
        for (int i = start; i < sz; ++i) {
            String n = this.getName(i);
            if (!(name == null ? n == null : name.equals(n))) continue;
            return i;
        }
        return -1;
    }

    public T get(String name) {
        return this.get(name, 0);
    }

    public T get(String name, int start) {
        int sz = this.size();
        for (int i = start; i < sz; ++i) {
            String n = this.getName(i);
            if (!(name == null ? n == null : name.equals(n))) continue;
            return this.getVal(i);
        }
        return null;
    }

    public List<T> getAll(String name) {
        ArrayList<T> result = new ArrayList<T>();
        int sz = this.size();
        for (int i = 0; i < sz; ++i) {
            String n = this.getName(i);
            if (name != n && (name == null || !name.equals(n))) continue;
            result.add(this.getVal(i));
        }
        return result;
    }

    private void killAll(String name) {
        int sz = this.size();
        for (int i = sz - 1; i >= 0; --i) {
            String n = this.getName(i);
            if (name != n && (name == null || !name.equals(n))) continue;
            this.remove(i);
        }
    }

    public Object findRecursive(String ... args) {
        NamedList currentList = null;
        Object value = null;
        for (int i = 0; i < args.length; ++i) {
            String key = args[i];
            if (currentList == null) {
                currentList = this;
            } else if (value instanceof NamedList) {
                currentList = value;
            } else {
                value = null;
                break;
            }
            value = currentList.get(key, 0);
        }
        return value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        int sz = this.size();
        for (int i = 0; i < sz; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(this.getName(i));
            sb.append('=');
            sb.append(this.getVal(i));
        }
        sb.append('}');
        return sb.toString();
    }

    public NamedList getImmutableCopy() {
        Object copy = this.clone();
        return new NamedList<T>(Collections.unmodifiableList(((NamedList)copy).nvPairs));
    }

    public Map asMap(int maxDepth) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (int i = 0; i < this.size(); ++i) {
            T old;
            Object val = this.getVal(i);
            if (val instanceof NamedList && maxDepth > 0) {
                val = ((NamedList)val).asMap(maxDepth - 1);
            }
            if ((old = result.put(this.getName(i), val)) == null) continue;
            if (old instanceof List) {
                List list = (List)old;
                list.add(val);
                result.put(this.getName(i), old);
                continue;
            }
            ArrayList<T> l = new ArrayList<T>();
            l.add(old);
            l.add(val);
            result.put(this.getName(i), l);
        }
        return result;
    }

    public boolean addAll(Map<String, T> args) {
        for (Map.Entry<String, T> entry : args.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return args.size() > 0;
    }

    public boolean addAll(NamedList<T> nl) {
        this.nvPairs.addAll(nl.nvPairs);
        return nl.size() > 0;
    }

    public NamedList<T> clone() {
        ArrayList<Object> newList = new ArrayList<Object>(this.nvPairs.size());
        newList.addAll(this.nvPairs);
        return new NamedList<T>(newList);
    }

    @Override
    public Iterator<Map.Entry<String, T>> iterator() {
        final NamedList list = this;
        Iterator iter = new Iterator<Map.Entry<String, T>>(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < list.size();
            }

            @Override
            public Map.Entry<String, T> next() {
                final int index = this.idx++;
                Map.Entry nv = new Map.Entry<String, T>(){

                    @Override
                    public String getKey() {
                        return list.getName(index);
                    }

                    @Override
                    public T getValue() {
                        return list.getVal(index);
                    }

                    public String toString() {
                        return this.getKey() + "=" + this.getValue();
                    }

                    @Override
                    public T setValue(T value) {
                        return list.setVal(index, value);
                    }
                };
                return nv;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return iter;
    }

    public T remove(String name) {
        int idx = this.indexOf(name, 0);
        if (idx != -1) {
            return this.remove(idx);
        }
        return null;
    }

    public List<T> removeAll(String name) {
        List<Object> result = new ArrayList();
        result = this.getAll(name);
        if (result.size() > 0) {
            this.killAll(name);
            return result;
        }
        return null;
    }

    public Boolean removeBooleanArg(String name) {
        Boolean bool = this.getBooleanArg(name);
        if (null != bool) {
            this.remove(name);
        }
        return bool;
    }

    public Boolean getBooleanArg(String name) {
        Boolean bool;
        List<T> values = this.getAll(name);
        if (0 == values.size()) {
            return null;
        }
        if (values.size() > 1) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Only one '" + name + "' is allowed");
        }
        T o = this.get(name);
        if (o instanceof Boolean) {
            bool = (Boolean)o;
        } else if (o instanceof CharSequence) {
            bool = Boolean.parseBoolean(o.toString());
        } else {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'" + name + "' must have type Boolean or CharSequence; found " + o.getClass());
        }
        return bool;
    }

    public Collection<String> removeConfigArgs(String name) throws SolrException {
        List<T> objects = this.getAll(name);
        ArrayList<String> collection = new ArrayList<String>(this.size() / 2);
        String err = "init arg '" + name + "' must be a string " + "(ie: 'str'), or an array (ie: 'arr') containing strings; found: ";
        for (Object o : objects) {
            if (o instanceof String) {
                collection.add((String)o);
                continue;
            }
            if (o instanceof Object[]) {
                o = Arrays.asList((Object[])o);
            }
            if (o instanceof Collection) {
                for (Object item : (Collection)o) {
                    if (!(item instanceof String)) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, err + item.getClass());
                    }
                    collection.add((String)item);
                }
                continue;
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, err + o.getClass());
        }
        if (collection.size() > 0) {
            this.killAll(name);
        }
        return collection;
    }

    public void clear() {
        this.nvPairs.clear();
    }

    public int hashCode() {
        return this.nvPairs.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NamedList)) {
            return false;
        }
        NamedList nl = (NamedList)obj;
        return this.nvPairs.equals(nl.nvPairs);
    }

    public static final class NamedListEntry<T>
    implements Map.Entry<String, T> {
        private String key;
        private T value;

        public NamedListEntry() {
        }

        public NamedListEntry(String _key, T _value) {
            this.key = _key;
            this.value = _value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public T setValue(T _value) {
            T oldValue = this.value;
            this.value = _value;
            return oldValue;
        }
    }
}

