/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.util.Properties;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.CloudConfig;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.logging.LogWatcherConfig;
import org.apache.solr.update.UpdateShardHandlerConfig;

public class NodeConfig {
    private final String nodeName;
    private final String coreRootDirectory;
    private final String configSetBaseDirectory;
    private final String sharedLibDirectory;
    private final PluginInfo shardHandlerFactoryConfig;
    private final UpdateShardHandlerConfig updateShardHandlerConfig;
    private final String coreAdminHandlerClass;
    private final String collectionsAdminHandlerClass;
    private final String infoHandlerClass;
    private final LogWatcherConfig logWatcherConfig;
    private final CloudConfig cloudConfig;
    private final int coreLoadThreads;
    private final int transientCacheSize;
    private final boolean useSchemaCache;
    private final String managementPath;
    protected final SolrResourceLoader loader;
    protected final Properties solrProperties;

    private NodeConfig(String nodeName, String coreRootDirectory, String configSetBaseDirectory, String sharedLibDirectory, PluginInfo shardHandlerFactoryConfig, UpdateShardHandlerConfig updateShardHandlerConfig, String coreAdminHandlerClass, String collectionsAdminHandlerClass, String infoHandlerClass, LogWatcherConfig logWatcherConfig, CloudConfig cloudConfig, int coreLoadThreads, int transientCacheSize, boolean useSchemaCache, String managementPath, SolrResourceLoader loader, Properties solrProperties) {
        this.nodeName = nodeName;
        this.coreRootDirectory = coreRootDirectory;
        this.configSetBaseDirectory = configSetBaseDirectory;
        this.sharedLibDirectory = sharedLibDirectory;
        this.shardHandlerFactoryConfig = shardHandlerFactoryConfig;
        this.updateShardHandlerConfig = updateShardHandlerConfig;
        this.coreAdminHandlerClass = coreAdminHandlerClass;
        this.collectionsAdminHandlerClass = collectionsAdminHandlerClass;
        this.infoHandlerClass = infoHandlerClass;
        this.logWatcherConfig = logWatcherConfig;
        this.cloudConfig = cloudConfig;
        this.coreLoadThreads = coreLoadThreads;
        this.transientCacheSize = transientCacheSize;
        this.useSchemaCache = useSchemaCache;
        this.managementPath = managementPath;
        this.loader = loader;
        this.solrProperties = solrProperties;
        if (this.cloudConfig != null && this.coreLoadThreads < 2) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "SolrCloud requires a value of at least 2 for coreLoadThreads (configured value = " + this.coreLoadThreads + ")");
        }
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getCoreRootDirectory() {
        return this.coreRootDirectory;
    }

    public PluginInfo getShardHandlerFactoryPluginInfo() {
        return this.shardHandlerFactoryConfig;
    }

    public UpdateShardHandlerConfig getUpdateShardHandlerConfig() {
        return this.updateShardHandlerConfig;
    }

    @Deprecated
    public int getDistributedConnectionTimeout() {
        return this.updateShardHandlerConfig.getDistributedConnectionTimeout();
    }

    @Deprecated
    public int getDistributedSocketTimeout() {
        return this.updateShardHandlerConfig.getDistributedSocketTimeout();
    }

    @Deprecated
    public int getMaxUpdateConnections() {
        return this.updateShardHandlerConfig.getMaxUpdateConnections();
    }

    @Deprecated
    public int getMaxUpdateConnectionsPerHost() {
        return this.updateShardHandlerConfig.getMaxUpdateConnectionsPerHost();
    }

    public int getCoreLoadThreadCount() {
        return this.coreLoadThreads;
    }

    public String getSharedLibDirectory() {
        return this.sharedLibDirectory;
    }

    public String getCoreAdminHandlerClass() {
        return this.coreAdminHandlerClass;
    }

    public String getCollectionsHandlerClass() {
        return this.collectionsAdminHandlerClass;
    }

    public String getInfoHandlerClass() {
        return this.infoHandlerClass;
    }

    public boolean hasSchemaCache() {
        return this.useSchemaCache;
    }

    public String getManagementPath() {
        return this.managementPath;
    }

    public String getConfigSetBaseDirectory() {
        return this.configSetBaseDirectory;
    }

    public LogWatcherConfig getLogWatcherConfig() {
        return this.logWatcherConfig;
    }

    public CloudConfig getCloudConfig() {
        return this.cloudConfig;
    }

    public int getTransientCacheSize() {
        return this.transientCacheSize;
    }

    public Properties getSolrProperties() {
        return this.solrProperties;
    }

    public SolrResourceLoader getSolrResourceLoader() {
        return this.loader;
    }

    public static class NodeConfigBuilder {
        private String coreRootDirectory = "";
        private String configSetBaseDirectory = "configsets";
        private String sharedLibDirectory = "lib";
        private PluginInfo shardHandlerFactoryConfig;
        private UpdateShardHandlerConfig updateShardHandlerConfig = UpdateShardHandlerConfig.DEFAULT;
        private String coreAdminHandlerClass = "org.apache.solr.handler.admin.CoreAdminHandler";
        private String collectionsAdminHandlerClass = "org.apache.solr.handler.admin.CollectionsHandler";
        private String infoHandlerClass = "org.apache.solr.handler.admin.InfoHandler";
        private LogWatcherConfig logWatcherConfig = new LogWatcherConfig(true, null, null, 50);
        private CloudConfig cloudConfig;
        private int coreLoadThreads = 3;
        private int transientCacheSize = Integer.MAX_VALUE;
        private boolean useSchemaCache = false;
        private String managementPath;
        private Properties solrProperties = new Properties();
        private final SolrResourceLoader loader;
        private final String nodeName;
        private static final int DEFAULT_CORE_LOAD_THREADS = 3;
        private static final int DEFAULT_TRANSIENT_CACHE_SIZE = Integer.MAX_VALUE;
        private static final String DEFAULT_ADMINHANDLERCLASS = "org.apache.solr.handler.admin.CoreAdminHandler";
        private static final String DEFAULT_INFOHANDLERCLASS = "org.apache.solr.handler.admin.InfoHandler";
        private static final String DEFAULT_COLLECTIONSHANDLERCLASS = "org.apache.solr.handler.admin.CollectionsHandler";

        public NodeConfigBuilder(String nodeName, SolrResourceLoader loader) {
            this.nodeName = nodeName;
            this.loader = loader;
            this.coreRootDirectory = loader.getInstanceDir();
        }

        public NodeConfigBuilder setCoreRootDirectory(String coreRootDirectory) {
            this.coreRootDirectory = this.loader.resolve(coreRootDirectory);
            return this;
        }

        public NodeConfigBuilder setConfigSetBaseDirectory(String configSetBaseDirectory) {
            this.configSetBaseDirectory = configSetBaseDirectory;
            return this;
        }

        public NodeConfigBuilder setSharedLibDirectory(String sharedLibDirectory) {
            this.sharedLibDirectory = sharedLibDirectory;
            return this;
        }

        public NodeConfigBuilder setShardHandlerFactoryConfig(PluginInfo shardHandlerFactoryConfig) {
            this.shardHandlerFactoryConfig = shardHandlerFactoryConfig;
            return this;
        }

        public NodeConfigBuilder setUpdateShardHandlerConfig(UpdateShardHandlerConfig updateShardHandlerConfig) {
            this.updateShardHandlerConfig = updateShardHandlerConfig;
            return this;
        }

        public NodeConfigBuilder setCoreAdminHandlerClass(String coreAdminHandlerClass) {
            this.coreAdminHandlerClass = coreAdminHandlerClass;
            return this;
        }

        public NodeConfigBuilder setCollectionsAdminHandlerClass(String collectionsAdminHandlerClass) {
            this.collectionsAdminHandlerClass = collectionsAdminHandlerClass;
            return this;
        }

        public NodeConfigBuilder setInfoHandlerClass(String infoHandlerClass) {
            this.infoHandlerClass = infoHandlerClass;
            return this;
        }

        public NodeConfigBuilder setLogWatcherConfig(LogWatcherConfig logWatcherConfig) {
            this.logWatcherConfig = logWatcherConfig;
            return this;
        }

        public NodeConfigBuilder setCloudConfig(CloudConfig cloudConfig) {
            this.cloudConfig = cloudConfig;
            return this;
        }

        public NodeConfigBuilder setCoreLoadThreads(int coreLoadThreads) {
            this.coreLoadThreads = coreLoadThreads;
            return this;
        }

        public NodeConfigBuilder setTransientCacheSize(int transientCacheSize) {
            this.transientCacheSize = transientCacheSize;
            return this;
        }

        public NodeConfigBuilder setUseSchemaCache(boolean useSchemaCache) {
            this.useSchemaCache = useSchemaCache;
            return this;
        }

        public NodeConfigBuilder setManagementPath(String managementPath) {
            this.managementPath = managementPath;
            return this;
        }

        public NodeConfigBuilder setSolrProperties(Properties solrProperties) {
            this.solrProperties = solrProperties;
            return this;
        }

        public NodeConfig build() {
            return new NodeConfig(this.nodeName, this.coreRootDirectory, this.configSetBaseDirectory, this.sharedLibDirectory, this.shardHandlerFactoryConfig, this.updateShardHandlerConfig, this.coreAdminHandlerClass, this.collectionsAdminHandlerClass, this.infoHandlerClass, this.logWatcherConfig, this.cloudConfig, this.coreLoadThreads, this.transientCacheSize, this.useSchemaCache, this.managementPath, this.loader, this.solrProperties);
        }
    }
}

