/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.logging;

import java.util.Map;
import org.slf4j.MDC;

public class MDCUtils {
    public static void cleanupMDC(Map previousMDCContext) {
        if (previousMDCContext != null) {
            MDC.setContextMap((Map)previousMDCContext);
        }
    }

    public static void setMDC(String collection, String shard, String replica, String core) {
        MDCUtils.setCollection(collection);
        MDCUtils.setShard(shard);
        MDCUtils.setReplica(replica);
        MDCUtils.setCore(core);
    }

    public static void setCollection(String collection) {
        if (collection != null) {
            MDC.put((String)"collection", (String)collection);
        }
    }

    public static void setShard(String shard) {
        if (shard != null) {
            MDC.put((String)"shard", (String)shard);
        }
    }

    public static void setReplica(String replica) {
        if (replica != null) {
            MDC.put((String)"replica", (String)replica);
        }
    }

    public static void setCore(String core) {
        if (core != null) {
            MDC.put((String)"core", (String)core);
        }
    }

    public static void clearMDC() {
        MDC.remove((String)"collection");
        MDC.remove((String)"core");
        MDC.remove((String)"replica");
        MDC.remove((String)"shard");
    }
}

