/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryContext;
import org.apache.solr.search.SolrIndexSearcher;

public class FieldUtil {
    public static SortedDocValues getSortedDocValues(SolrIndexSearcher searcher, String field) throws IOException {
        SchemaField sf = searcher.getSchema().getField(field);
        QueryContext qContext = QueryContext.newContext(searcher);
        return FieldUtil.getSortedDocValues(qContext, sf, null);
    }

    public static SortedDocValues getSortedDocValues(QueryContext context, SchemaField field, QParser qparser) throws IOException {
        SortedDocValues si = context.searcher().getLeafReader().getSortedDocValues(field.getName());
        return si == null ? DocValues.emptySorted() : si;
    }

    public static SortedSetDocValues getSortedSetDocValues(QueryContext context, SchemaField field, QParser qparser) throws IOException {
        SortedSetDocValues si = context.searcher().getLeafReader().getSortedSetDocValues(field.getName());
        return si == null ? DocValues.emptySortedSet() : si;
    }
}

