/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.util.List;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCmdExecutor;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedMap {
    private static final Logger LOG = LoggerFactory.getLogger(DistributedMap.class);
    private static long DEFAULT_TIMEOUT = 300000L;
    private final String dir;
    private SolrZkClient zookeeper;
    private final String prefix = "mn-";
    private final String response_prefix = "mnr-";

    public DistributedMap(SolrZkClient zookeeper, String dir, List<ACL> acl) {
        this.dir = dir;
        ZkCmdExecutor cmdExecutor = new ZkCmdExecutor(zookeeper.getZkClientTimeout());
        try {
            cmdExecutor.ensureExists(dir, zookeeper);
        }
        catch (KeeperException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        this.zookeeper = zookeeper;
    }

    private String createData(String path, byte[] data, CreateMode mode) throws KeeperException, InterruptedException {
        while (true) {
            try {
                return this.zookeeper.create(path, data, mode, true);
            }
            catch (KeeperException.NoNodeException e) {
                try {
                    this.zookeeper.create(this.dir, new byte[0], CreateMode.PERSISTENT, true);
                }
                catch (KeeperException.NodeExistsException ne) {
                }
                continue;
            }
            break;
        }
    }

    public boolean put(String trackingId, byte[] data) throws KeeperException, InterruptedException {
        return this.createData(this.dir + "/" + "mn-" + trackingId, data, CreateMode.PERSISTENT) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapEvent put(String trackingId, byte[] data, long timeout) throws KeeperException, InterruptedException {
        String path = this.createData(this.dir + "/" + "mn-" + trackingId, data, CreateMode.PERSISTENT);
        String watchID = this.createData(this.dir + "/" + "mnr-" + path.substring(path.lastIndexOf("-") + 1), null, CreateMode.EPHEMERAL);
        Object lock = new Object();
        LatchChildWatcher watcher = new LatchChildWatcher(lock);
        Object object = lock;
        synchronized (object) {
            if (this.zookeeper.exists(watchID, (Watcher)watcher, true) != null) {
                watcher.await(timeout);
            }
        }
        byte[] bytes = this.zookeeper.getData(watchID, null, null, true);
        this.zookeeper.delete(watchID, -1, true);
        return new MapEvent(watchID, bytes, watcher.getWatchedEvent());
    }

    public MapEvent get(String trackingId) throws KeeperException, InterruptedException {
        return new MapEvent(trackingId, this.zookeeper.getData(this.dir + "/" + "mn-" + trackingId, null, null, true), null);
    }

    public boolean contains(String trackingId) throws KeeperException, InterruptedException {
        return this.zookeeper.exists(this.dir + "/" + "mn-" + trackingId, true);
    }

    public int size() throws KeeperException, InterruptedException {
        Stat stat = new Stat();
        this.zookeeper.getData(this.dir, null, stat, true);
        return stat.getNumChildren();
    }

    public void remove(String trackingId) throws KeeperException, InterruptedException {
        this.zookeeper.delete(this.dir + "/" + "mn-" + trackingId, -1, true);
    }

    public void clear() throws KeeperException, InterruptedException {
        List childNames = this.zookeeper.getChildren(this.dir, null, true);
        for (String childName : childNames) {
            this.zookeeper.delete(this.dir + "/" + childName, -1, true);
        }
    }

    public static class MapEvent {
        private WatchedEvent event = null;
        private String id;
        private byte[] bytes;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MapEvent other = (MapEvent)obj;
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }

        MapEvent(String id, byte[] bytes, WatchedEvent event) {
            this.id = id;
            this.bytes = bytes;
            this.event = event;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public void setBytes(byte[] bytes) {
            this.bytes = bytes;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public WatchedEvent getWatchedEvent() {
            return this.event;
        }
    }

    private class LatchChildWatcher
    implements Watcher {
        Object lock = new Object();
        private WatchedEvent event = null;

        public LatchChildWatcher() {
        }

        public LatchChildWatcher(Object lock) {
            this.lock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent event) {
            LOG.info("LatchChildWatcher fired on path: " + event.getPath() + " state: " + event.getState() + " type " + event.getType());
            Object object = this.lock;
            synchronized (object) {
                this.event = event;
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void await(long timeout) throws InterruptedException {
            Object object = this.lock;
            synchronized (object) {
                this.lock.wait(timeout);
            }
        }

        public WatchedEvent getWatchedEvent() {
            return this.event;
        }
    }
}

