/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.BinaryQueryResponseWriter;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.util.FastWriter;

public final class QueryResponseWriterUtil {
    private QueryResponseWriterUtil() {
    }

    public static void writeQueryResponse(OutputStream outputStream, QueryResponseWriter responseWriter, SolrQueryRequest solrRequest, SolrQueryResponse solrResponse, String contentType) throws IOException {
        if (responseWriter instanceof BinaryQueryResponseWriter) {
            BinaryQueryResponseWriter binWriter = (BinaryQueryResponseWriter)responseWriter;
            binWriter.write(outputStream, solrRequest, solrResponse);
        } else {
            Writer writer = QueryResponseWriterUtil.buildWriter(outputStream, ContentStreamBase.getCharsetFromContentType((String)contentType));
            responseWriter.write(writer, solrRequest, solrResponse);
            writer.flush();
        }
    }

    private static Writer buildWriter(OutputStream outputStream, String charset) throws UnsupportedEncodingException {
        OutputStreamWriter writer = charset == null ? new OutputStreamWriter(outputStream, StandardCharsets.UTF_8) : new OutputStreamWriter(outputStream, charset);
        return new FastWriter(writer);
    }
}

