/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.internal.bind;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.internal.bind.MiniGson;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.internal.bind.ObjectTypeAdapter$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.internal.bind.TypeAdapter;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.internal.bind.TypeAdapter$Factory;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.stream.JsonReader;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.stream.JsonToken;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.stream.JsonWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public final class ObjectTypeAdapter
extends TypeAdapter {
    public static final TypeAdapter$Factory FACTORY = new ObjectTypeAdapter$1();
    private final MiniGson miniGson;

    private ObjectTypeAdapter(MiniGson miniGson) {
        this.miniGson = miniGson;
    }

    public Object read(JsonReader jsonReader) {
        JsonToken jsonToken = jsonReader.peek();
        switch (jsonToken) {
            case BEGIN_ARRAY: {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                jsonReader.beginArray();
                while (jsonReader.hasNext()) {
                    arrayList.add(this.read(jsonReader));
                }
                jsonReader.endArray();
                return arrayList;
            }
            case BEGIN_OBJECT: {
                LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
                jsonReader.beginObject();
                while (jsonReader.hasNext()) {
                    linkedHashMap.put(jsonReader.nextName(), this.read(jsonReader));
                }
                jsonReader.endObject();
                return linkedHashMap;
            }
            case STRING: {
                return jsonReader.nextString();
            }
            case NUMBER: {
                return jsonReader.nextDouble();
            }
            case BOOLEAN: {
                return jsonReader.nextBoolean();
            }
            case NULL: {
                jsonReader.nextNull();
                return null;
            }
        }
        throw new IllegalStateException();
    }

    public void write(JsonWriter jsonWriter, Object object) {
        if (object == null) {
            jsonWriter.nullValue();
            return;
        }
        TypeAdapter typeAdapter = this.miniGson.getAdapter(object.getClass());
        if (typeAdapter instanceof ObjectTypeAdapter) {
            jsonWriter.beginObject();
            jsonWriter.endObject();
            return;
        }
        typeAdapter.write(jsonWriter, object);
    }

    /* synthetic */ ObjectTypeAdapter(MiniGson miniGson, ObjectTypeAdapter$1 objectTypeAdapter$1) {
        this(miniGson);
    }
}

