/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect.TypeResolver$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect.TypeResolver$TypeMappingIntrospector;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect.TypeResolver$TypeTable;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect.Types;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect.Types$WildcardTypeImpl;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Map;

public final class TypeResolver {
    private final TypeResolver$TypeTable typeTable;

    public TypeResolver() {
        this.typeTable = new TypeResolver$TypeTable();
    }

    private TypeResolver(TypeResolver$TypeTable typeResolver$TypeTable) {
        this.typeTable = typeResolver$TypeTable;
    }

    static TypeResolver accordingTo(Type type) {
        return new TypeResolver().where(TypeResolver$TypeMappingIntrospector.getTypeMappings(type));
    }

    TypeResolver where(Map map) {
        return new TypeResolver(this.typeTable.where(map));
    }

    private static void populateTypeMappings(Map map, Type type, Type type2) {
        if (type.equals(type2)) {
            return;
        }
        new TypeResolver$1(map, type2).visit(type);
    }

    public Type resolveType(Type type) {
        Preconditions.checkNotNull(type);
        if (type instanceof TypeVariable) {
            return this.typeTable.resolve((TypeVariable)type);
        }
        if (type instanceof ParameterizedType) {
            return this.resolveParameterizedType((ParameterizedType)type);
        }
        if (type instanceof GenericArrayType) {
            return this.resolveGenericArrayType((GenericArrayType)type);
        }
        if (type instanceof WildcardType) {
            return this.resolveWildcardType((WildcardType)type);
        }
        return type;
    }

    private Type[] resolveTypes(Type[] typeArray) {
        Type[] typeArray2 = new Type[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            typeArray2[i] = this.resolveType(typeArray[i]);
        }
        return typeArray2;
    }

    private WildcardType resolveWildcardType(WildcardType wildcardType) {
        Type[] typeArray = wildcardType.getLowerBounds();
        Type[] typeArray2 = wildcardType.getUpperBounds();
        return new Types$WildcardTypeImpl(this.resolveTypes(typeArray), this.resolveTypes(typeArray2));
    }

    private Type resolveGenericArrayType(GenericArrayType genericArrayType) {
        Type type = genericArrayType.getGenericComponentType();
        Type type2 = this.resolveType(type);
        return Types.newArrayType(type2);
    }

    private ParameterizedType resolveParameterizedType(ParameterizedType parameterizedType) {
        Type type = parameterizedType.getOwnerType();
        Type type2 = type == null ? null : this.resolveType(type);
        Type type3 = this.resolveType(parameterizedType.getRawType());
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        Type[] typeArray2 = this.resolveTypes(typeArray);
        return Types.newParameterizedTypeWithOwner(type2, (Class)type3, typeArray2);
    }

    private static Object expectArgument(Class clazz, Object object) {
        try {
            return clazz.cast(object);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(object + " is not a " + clazz.getSimpleName());
        }
    }

    static /* synthetic */ Object access$000(Class clazz, Object object) {
        return TypeResolver.expectArgument(clazz, object);
    }

    static /* synthetic */ void access$100(Map map, Type type, Type type2) {
        TypeResolver.populateTypeMappings(map, type, type2);
    }

    /* synthetic */ TypeResolver(TypeResolver$TypeTable typeResolver$TypeTable, TypeResolver$1 typeResolver$1) {
        this(typeResolver$TypeTable);
    }

    static /* synthetic */ Type[] access$300(TypeResolver typeResolver, Type[] typeArray) {
        return typeResolver.resolveTypes(typeArray);
    }
}

