/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.convert;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import org.dataone.cn.indexer.convert.IConverter;

public class SolrDateConverter
implements IConverter {
    private static TimeZone OUTPUT_TIMEZONE = TimeZone.getTimeZone("Zulu");
    protected static final String OUTPUT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";

    @Override
    public String convert(String data) {
        if (data == null || data.equals("")) {
            return "";
        }
        Calendar cal = DatatypeConverter.parseDateTime((String)data);
        SimpleDateFormat sdf = new SimpleDateFormat(OUTPUT_DATE_FORMAT);
        sdf.setTimeZone(OUTPUT_TIMEZONE);
        String outputDateFormat = sdf.format(cal.getTime());
        return outputDateFormat;
    }

    public static Date ParseSolrDate(String date) {
        Date outputDate = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(OUTPUT_DATE_FORMAT);
            outputDate = sdf.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
        return outputDate;
    }
}

