/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.utilities;

import gov.loc.repository.bagit.utilities.SimpleMessage;
import gov.loc.repository.bagit.utilities.SimpleResult;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SimpleResultHelper {
    public static void missingPayloadFile(SimpleResult result, String manifest, String filepath) {
        result.setSuccess(false);
        result.addMessage("payload_manifest_contains_missing_file", "Payload manifest {0} contains missing file(s): {1}", manifest, filepath);
    }

    public static void missingTagFile(SimpleResult result, String manifest, String filepath) {
        result.setSuccess(false);
        result.addMessage("tag_manifest_contains_missing_file", "Tag manifest {0} contains missing file(s): {1}", manifest, filepath);
    }

    public static void invalidPayloadFile(SimpleResult result, String manifest, String filepath) {
        result.setSuccess(false);
        result.addMessage("payload_manifest_contains_invalid_file", "Payload manifest {0} contains invalid file(s): {1}", manifest, filepath);
    }

    public static void invalidTagFile(SimpleResult result, String manifest, String filepath) {
        result.setSuccess(false);
        result.addMessage("tag_manifest_contains_invalid_file", "Tag manifest {0} contains invalid files: {1}", manifest, filepath);
    }

    public static boolean isMissingOrInvalid(SimpleResult result, String filepath) {
        if (SimpleResultHelper.containsObject(result, "tag_manifest_contains_missing_file", filepath)) {
            return true;
        }
        if (SimpleResultHelper.containsObject(result, "payload_manifest_contains_missing_file", filepath)) {
            return true;
        }
        if (SimpleResultHelper.containsObject(result, "tag_manifest_contains_invalid_file", filepath)) {
            return true;
        }
        return SimpleResultHelper.containsObject(result, "payload_manifest_contains_invalid_file", filepath);
    }

    public static boolean containsObject(SimpleResult result, String code, String object) {
        List<SimpleMessage> messages = result.getSimpleMessagesByCode(code);
        for (SimpleMessage message : messages) {
            if (!message.getObjects().contains(object)) continue;
            return true;
        }
        return false;
    }

    public static Set<String> aggregateObjects(SimpleResult result, String code) {
        HashSet<String> objects = new HashSet<String>();
        List<SimpleMessage> messages = result.getSimpleMessagesByCode(code);
        for (SimpleMessage message : messages) {
            objects.addAll(message.getObjects());
        }
        return objects;
    }

    public static Set<String> aggregateSubjects(SimpleResult result, String code) {
        HashSet<String> subjects = new HashSet<String>();
        List<SimpleMessage> messages = result.getSimpleMessagesByCode(code);
        for (SimpleMessage message : messages) {
            subjects.add(message.getSubject());
        }
        return subjects;
    }

    public static Set<String> getInvalidTagFiles(SimpleResult result) {
        return SimpleResultHelper.aggregateObjects(result, "tag_manifest_contains_invalid_file");
    }

    public static Set<String> getInvalidPayloadFiles(SimpleResult result) {
        return SimpleResultHelper.aggregateObjects(result, "payload_manifest_contains_invalid_file");
    }

    public static Set<String> getMissingTagFiles(SimpleResult result) {
        return SimpleResultHelper.aggregateObjects(result, "tag_manifest_contains_missing_file");
    }

    public static Set<String> getMissingPayloadFiles(SimpleResult result) {
        return SimpleResultHelper.aggregateObjects(result, "payload_manifest_contains_missing_file");
    }

    public static Set<String> getExtraPayloadFiles(SimpleResult result) {
        return SimpleResultHelper.aggregateSubjects(result, "payload_file_not_in_payload_manifest");
    }
}

