/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.lib;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.sparql.sse.writers.WriterGraph;
import java.util.Iterator;
import org.apache.jena.atlas.io.IndentedWriter;

public class DatasetLib {
    public static void dump(DatasetGraph dataset) {
        WriterGraph.output(IndentedWriter.stdout, dataset, null);
        IndentedWriter.stdout.flush();
    }

    public static boolean isomorphic(Dataset dataset1, Dataset dataset2) {
        return DatasetLib.isomorphic(dataset1.asDatasetGraph(), dataset2.asDatasetGraph());
    }

    public static boolean isomorphic(DatasetGraph dataset1, DatasetGraph dataset2) {
        long x1 = dataset1.size();
        long x2 = dataset2.size();
        if (x1 >= 0L && x1 != x2) {
            return false;
        }
        boolean b = dataset1.getDefaultGraph().isIsomorphicWith(dataset2.getDefaultGraph());
        if (!b) {
            return b;
        }
        Iterator<Node> iter1 = dataset1.listGraphNodes();
        while (iter1.hasNext()) {
            Node gn = iter1.next();
            Graph g1 = dataset1.getGraph(gn);
            Graph g2 = dataset2.getGraph(gn);
            if (g2 == null) {
                return false;
            }
            if (g1.isIsomorphicWith(g2)) continue;
            return false;
        }
        return true;
    }

    public static DatasetGraph createDatasetGraphMem() {
        return DatasetGraphFactory.createMem();
    }
}

