/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client.rest;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.dataone.mimemultipart.SimpleMultipartEntity;

public class RestClient {
    protected static Log log = LogFactory.getLog(RestClient.class);
    protected HttpClient httpClient;
    protected HashMap<String, String> headers = new HashMap();
    private Map<Long, String> perThreadLatestRequestUrlMap = new HashMap<Long, String>();

    public RestClient(HttpClient client) {
        this.httpClient = client;
    }

    public String getLatestRequestUrl() {
        long threadId = Thread.currentThread().getId();
        return this.perThreadLatestRequestUrlMap.get(threadId);
    }

    private void setLatestRequestUrl(String value) {
        long threadId = Thread.currentThread().getId();
        this.perThreadLatestRequestUrlMap.put(threadId, value);
    }

    public String getLatestRequestUrl(Thread t) {
        long threadId = t.getId();
        return this.perThreadLatestRequestUrlMap.get(threadId);
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Deprecated
    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    @Deprecated
    public HashMap<String, String> getAddedHeaders() {
        return this.headers;
    }

    @Deprecated
    public void clearAddedHeaders() {
        this.headers.clear();
    }

    public HttpResponse doGetRequest(String url, RequestConfig requestConfig) throws ClientProtocolException, IOException {
        return this.doRequestNoBody(url, "GET", requestConfig);
    }

    public HttpResponse doHeadRequest(String url, RequestConfig requestConfig) throws ClientProtocolException, IOException {
        return this.doRequestNoBody(url, "HEAD", requestConfig);
    }

    public HttpResponse doDeleteRequest(String url, RequestConfig requestConfig) throws ClientProtocolException, IOException {
        return this.doRequestNoBody(url, "DELETE", requestConfig);
    }

    public HttpResponse doPostRequest(String url, SimpleMultipartEntity mpe, RequestConfig requestConfig) throws ClientProtocolException, IOException {
        return this.doRequestMMBody(url, "POST", mpe, requestConfig);
    }

    public HttpResponse doPutRequest(String url, SimpleMultipartEntity mpe, RequestConfig requestConfig) throws ClientProtocolException, IOException {
        return this.doRequestMMBody(url, "PUT", mpe, requestConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse doRequestNoBody(String url, String httpMethod, RequestConfig requestConfig) throws ClientProtocolException, IOException {
        String latestCall = httpMethod + " " + url;
        HttpResponse response = null;
        try {
            HttpGet req = null;
            if (httpMethod == "GET") {
                req = new HttpGet(url);
            } else if (httpMethod == "HEAD") {
                req = new HttpHead(url);
            } else if (httpMethod == "DELETE") {
                req = new HttpDelete(url);
            } else {
                throw new ClientProtocolException("method requested not defined: " + httpMethod);
            }
            req.setConfig(requestConfig);
            response = this.doRequest((HttpUriRequest)req);
        }
        finally {
            this.setLatestRequestUrl(latestCall);
            log.info((Object)("RestClient.doRequestNoBody, thread(" + Thread.currentThread().getId() + ") call Info: " + latestCall));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse doRequestMMBody(String url, String httpMethod, SimpleMultipartEntity mpe, RequestConfig requestConfig) throws ClientProtocolException, IOException {
        String latestCall = httpMethod + " " + url;
        HttpResponse response = null;
        try {
            HttpPut req = null;
            if (httpMethod == "PUT") {
                req = new HttpPut(url);
            } else if (httpMethod == "POST") {
                req = new HttpPost(url);
            } else {
                throw new ClientProtocolException("method requested not defined: " + httpMethod);
            }
            if (mpe != null) {
                req.setEntity((HttpEntity)mpe);
                latestCall = latestCall + "; MMP message has: " + mpe.getDescription();
            } else {
                latestCall = latestCall + "; MMP entity is null";
            }
            if (requestConfig != null) {
                req.setConfig(requestConfig);
            }
            response = this.doRequest((HttpUriRequest)req);
        }
        finally {
            this.setLatestRequestUrl(latestCall);
            log.info((Object)("RestClient.doRequestMMPBody, thread(" + Thread.currentThread().getId() + ") call Info: " + latestCall));
            if (mpe != null && !mpe.cleanupTempFiles()) {
                log.warn((Object)("Failed to clean up temp files for: " + httpMethod + " " + url));
            }
        }
        return response;
    }

    private HttpResponse doRequest(HttpUriRequest req) throws ClientProtocolException, IOException {
        for (String n : this.headers.keySet()) {
            req.setHeader(n, this.headers.get(n));
        }
        return this.httpClient.execute(req);
    }
}

