/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client.v2.formats;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.configuration.Settings;
import org.dataone.service.types.v1.ObjectFormat;

public class ObjectFormatInfo {
    private static Log log = LogFactory.getLog(ObjectFormatInfo.class);
    private Map<String, String> mimeMap = new HashMap<String, String>(capacityEstimate);
    private Map<String, String> extMap = new HashMap<String, String>(capacityEstimate);
    private static ObjectFormatInfo self = null;
    private static int capacityEstimate = 125;
    private static final String MAPPING_FILENAME = "mime-mappings.csv";
    private static final String DEFAULT_RESOURCE_DIR = "DataONE";

    private ObjectFormatInfo() {
        this.loadMappings();
    }

    public static ObjectFormatInfo instance() {
        if (null == self) {
            self = new ObjectFormatInfo();
        }
        return self;
    }

    public static void reload() {
        self = new ObjectFormatInfo();
    }

    public String getMimeType(String formatID) {
        return this.mimeMap.get(formatID);
    }

    public String getMimeType(ObjectFormat format) {
        return this.mimeMap.get(format.getFormatId().getValue());
    }

    public String getExtension(String formatID) {
        return this.extMap.get(formatID);
    }

    public String getExtension(ObjectFormat format) {
        return this.extMap.get(format.getFormatId().getValue());
    }

    private void loadMappings() {
        assert (this.mimeMap != null);
        assert (this.extMap != null);
        try {
            File mappingFile = this.findMappingFile();
            FileInputStream fis = new FileInputStream(mappingFile);
            this.parseMappingFile(fis);
        }
        catch (IOException e) {
            log.warn((Object)("Problem reading or saving mapping file, so using internal version: " + e.getMessage()));
            InputStream mappingStream = ObjectFormatInfo.class.getResourceAsStream(MAPPING_FILENAME);
            try {
                this.parseMappingFile(mappingStream);
            }
            catch (IOException e1) {
                log.error((Object)("Serious error while trying to read mapping data: " + e1.getMessage()));
            }
        }
    }

    private void parseMappingFile(InputStream is) throws IOException {
        InputStreamReader isr = new InputStreamReader(is, "UTF-8");
        BufferedReader csv = new BufferedReader(isr);
        String line = csv.readLine();
        while (line != null) {
            String[] fields;
            line = csv.readLine();
            if (line == null || (fields = line.split(",")).length != 3) continue;
            this.mimeMap.put(fields[0], fields[1]);
            this.extMap.put(fields[0], fields[2]);
        }
        csv.close();
    }

    private File findMappingFile() throws IOException {
        File mappingFile = null;
        String resourcesDirName = Settings.getConfiguration().getString("D1Client.resourcesDir");
        if (resourcesDirName == null) {
            String home = System.getProperty("user.home");
            File resourcesDir = new File(home, DEFAULT_RESOURCE_DIR);
            mappingFile = this.getOrCreateMappingFile(resourcesDir);
        } else {
            File resourcesDir = new File(resourcesDirName);
            mappingFile = this.getOrCreateMappingFile(resourcesDir);
        }
        return mappingFile;
    }

    private File getOrCreateMappingFile(File resourcesDir) throws IOException {
        File mappingFile = null;
        mappingFile = new File(resourcesDir, MAPPING_FILENAME);
        if (mappingFile.exists()) {
            return mappingFile;
        }
        InputStream mappingStream = ObjectFormatInfo.class.getResourceAsStream(MAPPING_FILENAME);
        if (!resourcesDir.exists()) {
            boolean bl = resourcesDir.mkdirs();
        }
        mappingFile.createNewFile();
        FileOutputStream mappingFileStream = new FileOutputStream(mappingFile);
        IOUtils.copy((InputStream)mappingStream, (OutputStream)mappingFileStream);
        mappingFileStream.close();
        return mappingFile;
    }
}

