/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.tdb.TDBException;
import java.math.BigDecimal;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.jena.atlas.lib.BitsInt;
import org.apache.jena.atlas.lib.BitsLong;
import org.apache.jena.atlas.lib.NumberUtils;

public class DateTimeNode {
    static final int DATE_LEN = 22;
    static final int TIME_LEN = 27;
    static final int MILLI = 0;
    static final int MILLI_LEN = 16;
    static final int MINUTES = 16;
    static final int MINUTES_LEN = 6;
    static final int HOUR = 22;
    static final int HOUR_LEN = 5;
    static final int DAY = 27;
    static final int DAY_LEN = 5;
    static final int MONTH = 32;
    static final int MONTH_LEN = 4;
    static final int YEAR = 36;
    static final int YEAR_LEN = 13;
    static final int TZ = 49;
    static final int TZ_LEN = 7;
    static final int TZ_Z = 127;
    static final int TZ_NONE = 126;
    static DatatypeFactory datatypeFactory = null;

    static long time(long v, int hour, int mins, int millisec) {
        v = BitsLong.pack((long)v, (long)hour, (int)22, (int)27);
        v = BitsLong.pack((long)v, (long)mins, (int)16, (int)22);
        v = BitsLong.pack((long)v, (long)millisec, (int)0, (int)16);
        return v;
    }

    static long date(long v, int year, int month, int day) {
        v = BitsLong.pack((long)v, (long)year, (int)36, (int)49);
        v = BitsLong.pack((long)v, (long)month, (int)32, (int)36);
        v = BitsLong.pack((long)v, (long)day, (int)27, (int)32);
        return v;
    }

    static long tz(long v, int tz_in_quarters) {
        v = BitsLong.pack((long)v, (long)tz_in_quarters, (int)49, (int)56);
        return v;
    }

    public static long packDate(String lex) {
        return DateTimeNode.packDateTime(lex);
    }

    public static long packDateTime(String lex) {
        try {
            return DateTimeNode.packDateTime$(lex);
        }
        catch (Exception ex) {
            return -1L;
        }
    }

    private static long packDateTime$(String lex) {
        BigDecimal fs;
        long v = 0L;
        boolean containsZ = (lex = lex.trim()).indexOf(90) > 0;
        XMLGregorianCalendar xcal = datatypeFactory.newXMLGregorianCalendar(lex);
        if (xcal.getFractionalSecond() != null && (fs = xcal.getFractionalSecond()).doubleValue() != (double)xcal.getMillisecond() / 1000.0) {
            return -1L;
        }
        int y = xcal.getYear();
        if (y < 0 || y >= 8000) {
            return -1L;
        }
        v = DateTimeNode.date(v, xcal.getYear(), xcal.getMonth(), xcal.getDay());
        v = DateTimeNode.time(v, xcal.getHour(), xcal.getMinute(), xcal.getSecond() * 1000 + xcal.getMillisecond());
        if (containsZ) {
            return DateTimeNode.tz(v, 127);
        }
        int tz = xcal.getTimezone();
        if (tz == Integer.MIN_VALUE) {
            return DateTimeNode.tz(v, 126);
        }
        if (tz % 15 != 0) {
            return -1L;
        }
        return DateTimeNode.tz(v, tz /= 15);
    }

    public static String unpackDateTime(long v) {
        return DateTimeNode.unpack(v, true);
    }

    public static String unpackDate(long v) {
        return DateTimeNode.unpack(v, false);
    }

    private static String unpack(long v, boolean isDateTime) {
        int years = (int)BitsLong.unpack((long)v, (int)36, (int)49);
        int months = (int)BitsLong.unpack((long)v, (int)32, (int)36);
        int days = (int)BitsLong.unpack((long)v, (int)27, (int)32);
        int hours = (int)BitsLong.unpack((long)v, (int)22, (int)27);
        int minutes = (int)BitsLong.unpack((long)v, (int)16, (int)22);
        int milliSeconds = (int)BitsLong.unpack((long)v, (int)0, (int)16);
        int tz = (int)BitsLong.unpack((long)v, (int)49, (int)56);
        int sec = milliSeconds / 1000;
        int fractionSec = milliSeconds % 1000;
        StringBuilder sb = new StringBuilder(50);
        NumberUtils.formatInt((StringBuilder)sb, (int)years, (int)4);
        sb.append('-');
        NumberUtils.formatInt((StringBuilder)sb, (int)months, (int)2);
        sb.append('-');
        NumberUtils.formatInt((StringBuilder)sb, (int)days, (int)2);
        if (isDateTime) {
            sb.append('T');
            NumberUtils.formatInt((StringBuilder)sb, (int)hours, (int)2);
            sb.append(':');
            NumberUtils.formatInt((StringBuilder)sb, (int)minutes, (int)2);
            sb.append(':');
            NumberUtils.formatInt((StringBuilder)sb, (int)sec, (int)2);
            if (fractionSec != 0) {
                sb.append(".");
                if (fractionSec % 100 == 0) {
                    NumberUtils.formatInt((StringBuilder)sb, (int)(fractionSec / 100), (int)1);
                } else if (fractionSec % 10 == 0) {
                    NumberUtils.formatInt((StringBuilder)sb, (int)(fractionSec / 10), (int)2);
                } else {
                    NumberUtils.formatInt((StringBuilder)sb, (int)fractionSec, (int)3);
                }
            }
        }
        if (tz == 127) {
            sb.append("Z");
            return sb.toString();
        }
        if (tz == 126) {
            return sb.toString();
        }
        if (BitsLong.isSet((long)v, (int)55)) {
            tz = BitsInt.set((int)tz, (int)7, (int)32);
        }
        if (tz < 0) {
            tz = -tz;
            sb.append('-');
        } else {
            sb.append('+');
        }
        int tzH = tz / 4;
        int tzM = tz % 4 * 15;
        NumberUtils.formatUnsignedInt((StringBuilder)sb, (int)tzH, (int)2);
        sb.append(':');
        NumberUtils.formatUnsignedInt((StringBuilder)sb, (int)tzM, (int)2);
        return sb.toString();
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException ex) {
            throw new TDBException("DateTimeNode", ex);
        }
    }
}

