/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.utilities.triple;

import java.util.Vector;

public class Triple {
    private String subject;
    private String relationship;
    private String object;

    public Triple() {
        this.subject = new String();
        this.relationship = new String();
        this.object = new String();
    }

    public Triple(String subject, String relationship, String object) {
        this.subject = subject;
        this.relationship = relationship;
        this.object = object;
    }

    public Triple(Triple t) {
        this.subject = t.getSubject();
        this.relationship = t.getRelationship();
        this.object = t.getObject();
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setRelationship(String relationship) {
        this.relationship = relationship;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getRelationship() {
        return this.relationship;
    }

    public String getObject() {
        return this.object;
    }

    public Vector<String> getTriple() {
        Vector<String> triple = new Vector<String>();
        triple.addElement(this.subject);
        triple.addElement(this.relationship);
        triple.addElement(this.object);
        return triple;
    }

    public String toXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<triple>");
        sb.append("<subject>").append(this.subject).append("</subject>");
        sb.append("<relationship>").append(this.relationship).append("</relationship>");
        sb.append("<object>").append(this.object).append("</object>");
        sb.append("</triple>");
        return sb.toString();
    }

    public String toFormatedXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<triple>\n");
        sb.append("  <subject>").append(this.subject).append("</subject>\n");
        sb.append("  <relationship>").append(this.relationship);
        sb.append("</relationship>\n");
        sb.append("  <object>").append(this.object).append("</object>\n");
        sb.append("</triple>\n");
        return sb.toString();
    }

    public String toString() {
        return "[" + this.subject + "," + this.relationship + "," + this.object + "]";
    }
}

