/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.util;

import java.math.BigInteger;
import org.dataone.exceptions.MarshallingException;

public class BigIntegerMarshaller {
    static final BigInteger minLimit = new BigInteger("0");
    static final BigInteger maxLimit = new BigInteger("18446744073709551615");

    public static String serializeBigInteger(BigInteger bigInt) throws MarshallingException {
        if (bigInt.compareTo(minLimit) >= 0 && bigInt.compareTo(maxLimit) <= 0) {
            return bigInt.toString();
        }
        throw new MarshallingException("unsignedLong must be greater than or equal to 0 and less than or equal to 18446744073709551615");
    }

    public static BigInteger deserializeBigInteger(String bigIntValue) throws MarshallingException {
        if (bigIntValue == null) {
            throw new MarshallingException("serialized value cannot be null");
        }
        BigInteger bigInt = new BigInteger(bigIntValue);
        if (bigInt.compareTo(minLimit) >= 0 && bigInt.compareTo(maxLimit) <= 0) {
            return bigInt;
        }
        throw new MarshallingException("unsignedLong must be greater than or equal to 0 and less than or equal to 18446744073709551615");
    }
}

