/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DateTimeMarshaller {
    static final Pattern timezonePattern = Pattern.compile(".+(?:(?:[\\+\\-]\\d\\d:\\d\\d)|Z)$");
    static final DateTimeFormatter basicDateIsoFmt = ISODateTimeFormat.basicDate();
    static final DateTimeFormatter basicDateTimeIsoFmt = ISODateTimeFormat.basicDateTime();
    static final DateTimeFormatter basicDateTimeNoMillisIsoFmt = ISODateTimeFormat.basicDateTimeNoMillis();
    static final DateTimeFormatter extendedDateIsoFmt = ISODateTimeFormat.date();
    static final DateTimeFormatter extendedDateTimeIsoFmt = ISODateTimeFormat.dateTime();
    static final DateTimeFormatter extendedDateTimeNoMillisIsoFmt = ISODateTimeFormat.dateTimeNoMillis();
    static final DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZZ");

    public static String serializeDateToUTC(Date d) {
        DateTime dt = new DateTime((Object)d);
        DateTime dtUTC = dt.withZone(DateTimeZone.UTC);
        return fmt.print((ReadableInstant)dtUTC);
    }

    public static Date deserializeDateToUTC(String dt) {
        DateTime dateTime = null;
        if (Character.isDigit(dt.charAt(0))) {
            String tzAppend = "";
            if (!timezonePattern.matcher(dt).matches()) {
                tzAppend = "Z";
            }
            dateTime = Character.isDigit(dt.charAt(4)) ? (dt.contains(".") ? basicDateTimeIsoFmt.parseDateTime(dt + tzAppend) : basicDateTimeNoMillisIsoFmt.parseDateTime(dt + tzAppend)) : (dt.contains(".") ? extendedDateTimeIsoFmt.parseDateTime(dt + tzAppend) : extendedDateTimeNoMillisIsoFmt.parseDateTime(dt + tzAppend));
        } else if (Character.isSpaceChar(dt.charAt(3))) {
            SimpleDateFormat format = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy");
            try {
                dateTime = new DateTime((Object)format.parse(dt));
            }
            catch (ParseException ex) {
                dateTime = null;
            }
        } else if (Character.isLetter(dt.charAt(3))) {
            SimpleDateFormat format = new SimpleDateFormat("EEEE, dd-MMM-yy HH:mm:ss zzz");
            try {
                dateTime = new DateTime((Object)format.parse(dt));
            }
            catch (ParseException ex) {
                dateTime = null;
            }
        } else {
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
            try {
                dateTime = new DateTime((Object)format.parse(dt));
            }
            catch (ParseException ex) {
                dateTime = null;
            }
        }
        dateTime = dateTime.withZone(DateTimeZone.UTC);
        return dateTime.toDate();
    }
}

