/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store.nodetable;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.setup.StoreParams;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.tdb.store.nodetable.NodeTable;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.atlas.lib.CacheSet;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.logging.Log;

public class NodeTableCache
implements NodeTable {
    private Cache<Node, NodeId> node2id_Cache = null;
    private Cache<NodeId, Node> id2node_Cache = null;
    private CacheSet<Node> notPresent = null;
    private NodeTable baseTable;
    private Object lock = new Object();

    public static NodeTable create(NodeTable nodeTable, StoreParams params) {
        int nodeToIdCacheSize = params.getNode2NodeIdCacheSize();
        int idToNodeCacheSize = params.getNodeId2NodeCacheSize();
        if (nodeToIdCacheSize <= 0 && idToNodeCacheSize <= 0) {
            return nodeTable;
        }
        return new NodeTableCache(nodeTable, nodeToIdCacheSize, idToNodeCacheSize, params.getNodeMissCacheSize());
    }

    public static NodeTable create(NodeTable nodeTable, int nodeToIdCacheSize, int idToNodeCacheSize, int nodeMissesCacheSize) {
        if (nodeToIdCacheSize <= 0 && idToNodeCacheSize <= 0) {
            return nodeTable;
        }
        return new NodeTableCache(nodeTable, nodeToIdCacheSize, idToNodeCacheSize, nodeMissesCacheSize);
    }

    private NodeTableCache(NodeTable baseTable, int nodeToIdCacheSize, int idToNodeCacheSize, int nodeMissesCacheSize) {
        this.baseTable = baseTable;
        if (nodeToIdCacheSize > 0) {
            this.node2id_Cache = CacheFactory.createCache((int)nodeToIdCacheSize);
        }
        if (idToNodeCacheSize > 0) {
            this.id2node_Cache = CacheFactory.createCache((int)idToNodeCacheSize);
        }
        if (nodeMissesCacheSize > 0) {
            this.notPresent = CacheFactory.createCacheSet((int)nodeMissesCacheSize);
        }
    }

    @Override
    public final NodeTable wrapped() {
        return this.baseTable;
    }

    @Override
    public Node getNodeForNodeId(NodeId id) {
        return this._retrieveNodeByNodeId(id);
    }

    @Override
    public NodeId getNodeIdForNode(Node node) {
        return this._idForNode(node, false);
    }

    @Override
    public NodeId getAllocateNodeId(Node node) {
        return this._idForNode(node, true);
    }

    @Override
    public boolean containsNode(Node node) {
        NodeId x = this.getNodeIdForNode(node);
        return NodeId.isDoesNotExist(x);
    }

    @Override
    public boolean containsNodeId(NodeId nodeId) {
        Node x = this.getNodeForNodeId(nodeId);
        return x == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node _retrieveNodeByNodeId(NodeId id) {
        if (NodeId.isDoesNotExist(id)) {
            return null;
        }
        if (NodeId.isAny(id)) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            Node n = this.cacheLookup(id);
            if (n != null) {
                return n;
            }
            if (this.baseTable == null) {
                System.err.println("" + this);
            }
            n = this.baseTable.getNodeForNodeId(id);
            this.cacheUpdate(n, id);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeId _idForNode(Node node, boolean allocate) {
        if (node == Node.ANY) {
            return NodeId.NodeIdAny;
        }
        Object object = this.lock;
        synchronized (object) {
            NodeId nodeId = this.cacheLookup(node);
            if (nodeId != null) {
                return nodeId;
            }
            nodeId = allocate ? this.baseTable.getAllocateNodeId(node) : this.baseTable.getNodeIdForNode(node);
            this.cacheUpdate(node, nodeId);
            return nodeId;
        }
    }

    private Node cacheLookup(NodeId id) {
        if (this.id2node_Cache == null) {
            return null;
        }
        return (Node)this.id2node_Cache.get((Object)id);
    }

    private NodeId cacheLookup(Node node) {
        if (this.notPresent != null && this.notPresent.contains((Object)node)) {
            return null;
        }
        if (this.node2id_Cache == null) {
            return null;
        }
        return (NodeId)this.node2id_Cache.get((Object)node);
    }

    private void cacheUpdate(Node node, NodeId id) {
        if (NodeId.isDoesNotExist(id)) {
            if (this.notPresent != null) {
                this.notPresent.add((Object)node);
            }
            return;
        }
        if (id == NodeId.NodeIdAny) {
            Log.warn((Object)this, (String)"Attempt to cache NodeIdAny - ignored");
            return;
        }
        if (this.node2id_Cache != null) {
            this.node2id_Cache.put((Object)node, (Object)id);
        }
        if (this.id2node_Cache != null) {
            this.id2node_Cache.put((Object)id, (Object)node);
        }
        if (this.notPresent != null && this.notPresent.contains((Object)node)) {
            this.notPresent.remove((Object)node);
        }
    }

    @Override
    public NodeId allocOffset() {
        return this.baseTable.allocOffset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            if (this.node2id_Cache != null) {
                return this.node2id_Cache.isEmpty();
            }
            if (this.id2node_Cache != null) {
                this.id2node_Cache.isEmpty();
            }
            return this.baseTable.isEmpty();
        }
    }

    public synchronized void close() {
        if (this.baseTable == null) {
            return;
        }
        this.baseTable.close();
        this.node2id_Cache = null;
        this.id2node_Cache = null;
        this.notPresent = null;
        this.baseTable = null;
    }

    public void sync() {
        this.baseTable.sync();
    }

    @Override
    public Iterator<Pair<NodeId, Node>> all() {
        return this.baseTable.all();
    }

    private void testForConsistency() {
        for (Node n : Iter.toList((Iterator)this.node2id_Cache.keys())) {
            NodeId nId = (NodeId)this.node2id_Cache.get((Object)n);
            if (!this.id2node_Cache.containsKey((Object)nId)) {
                throw new TDBException("Inconsistent: " + n + " => " + nId);
            }
            if (!this.notPresent.contains((Object)n)) continue;
            throw new TDBException("Inconsistent: " + n + " in notPresent cache (1)");
        }
        for (NodeId nId : Iter.toList((Iterator)this.id2node_Cache.keys())) {
            Node n = (Node)this.id2node_Cache.get((Object)nId);
            if (!this.node2id_Cache.containsKey((Object)n)) {
                throw new TDBException("Inconsistent: " + nId + " => " + n);
            }
            if (!this.notPresent.contains((Object)n)) continue;
            throw new TDBException("Inconsistent: " + n + " in notPresent cache (2)");
        }
    }

    public String toString() {
        return "Cache(" + this.baseTable.toString() + ")";
    }
}

