/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm.AnnotationVisitor;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm.ByteVector;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm.Symbol;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm.SymbolTable;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm.Type;

final class AnnotationWriter
extends AnnotationVisitor {
    private final SymbolTable symbolTable;
    private final boolean useNamedValues;
    private final ByteVector annotation;
    private final int numElementValuePairsOffset;
    private int numElementValuePairs;
    private final AnnotationWriter previousAnnotation;
    private AnnotationWriter nextAnnotation;

    AnnotationWriter(SymbolTable symbolTable, boolean bl, ByteVector byteVector, AnnotationWriter annotationWriter) {
        super(393216);
        this.symbolTable = symbolTable;
        this.useNamedValues = bl;
        this.annotation = byteVector;
        this.numElementValuePairsOffset = byteVector.length == 0 ? -1 : byteVector.length - 2;
        this.previousAnnotation = annotationWriter;
        if (annotationWriter != null) {
            annotationWriter.nextAnnotation = this;
        }
    }

    AnnotationWriter(SymbolTable symbolTable, ByteVector byteVector, AnnotationWriter annotationWriter) {
        this(symbolTable, true, byteVector, annotationWriter);
    }

    public void visit(String string, Object object) {
        ++this.numElementValuePairs;
        if (this.useNamedValues) {
            this.annotation.putShort(this.symbolTable.addConstantUtf8(string));
        }
        if (object instanceof String) {
            this.annotation.put12(115, this.symbolTable.addConstantUtf8((String)object));
        } else if (object instanceof Byte) {
            this.annotation.put12(66, this.symbolTable.addConstantInteger((int)((Byte)object).byteValue()).index);
        } else if (object instanceof Boolean) {
            int n = (Boolean)object != false ? 1 : 0;
            this.annotation.put12(90, this.symbolTable.addConstantInteger((int)n).index);
        } else if (object instanceof Character) {
            this.annotation.put12(67, this.symbolTable.addConstantInteger((int)((Character)object).charValue()).index);
        } else if (object instanceof Short) {
            this.annotation.put12(83, this.symbolTable.addConstantInteger((int)((Short)object).shortValue()).index);
        } else if (object instanceof Type) {
            this.annotation.put12(99, this.symbolTable.addConstantUtf8(((Type)object).getDescriptor()));
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            this.annotation.put12(91, byArray.length);
            for (byte by : byArray) {
                this.annotation.put12(66, this.symbolTable.addConstantInteger((int)by).index);
            }
        } else if (object instanceof boolean[]) {
            boolean[] blArray = (boolean[])object;
            this.annotation.put12(91, blArray.length);
            for (boolean bl : blArray) {
                this.annotation.put12(90, this.symbolTable.addConstantInteger((int)(bl ? 1 : 0)).index);
            }
        } else if (object instanceof short[]) {
            short[] sArray = (short[])object;
            this.annotation.put12(91, sArray.length);
            for (short s : sArray) {
                this.annotation.put12(83, this.symbolTable.addConstantInteger((int)s).index);
            }
        } else if (object instanceof char[]) {
            char[] cArray = (char[])object;
            this.annotation.put12(91, cArray.length);
            for (char c : cArray) {
                this.annotation.put12(67, this.symbolTable.addConstantInteger((int)c).index);
            }
        } else if (object instanceof int[]) {
            int[] nArray = (int[])object;
            this.annotation.put12(91, nArray.length);
            for (int n : nArray) {
                this.annotation.put12(73, this.symbolTable.addConstantInteger((int)n).index);
            }
        } else if (object instanceof long[]) {
            long[] lArray = (long[])object;
            this.annotation.put12(91, lArray.length);
            for (long l : lArray) {
                this.annotation.put12(74, this.symbolTable.addConstantLong((long)l).index);
            }
        } else if (object instanceof float[]) {
            float[] fArray = (float[])object;
            this.annotation.put12(91, fArray.length);
            for (float f : fArray) {
                this.annotation.put12(70, this.symbolTable.addConstantFloat((float)f).index);
            }
        } else if (object instanceof double[]) {
            double[] dArray = (double[])object;
            this.annotation.put12(91, dArray.length);
            for (double d : dArray) {
                this.annotation.put12(68, this.symbolTable.addConstantDouble((double)d).index);
            }
        } else {
            Symbol symbol = this.symbolTable.addConstant(object);
            this.annotation.put12(".s.IFJDCS".charAt(symbol.tag), symbol.index);
        }
    }

    public void visitEnum(String string, String string2, String string3) {
        ++this.numElementValuePairs;
        if (this.useNamedValues) {
            this.annotation.putShort(this.symbolTable.addConstantUtf8(string));
        }
        this.annotation.put12(101, this.symbolTable.addConstantUtf8(string2)).putShort(this.symbolTable.addConstantUtf8(string3));
    }

    public AnnotationVisitor visitAnnotation(String string, String string2) {
        ++this.numElementValuePairs;
        if (this.useNamedValues) {
            this.annotation.putShort(this.symbolTable.addConstantUtf8(string));
        }
        this.annotation.put12(64, this.symbolTable.addConstantUtf8(string2)).putShort(0);
        return new AnnotationWriter(this.symbolTable, this.annotation, null);
    }

    public AnnotationVisitor visitArray(String string) {
        ++this.numElementValuePairs;
        if (this.useNamedValues) {
            this.annotation.putShort(this.symbolTable.addConstantUtf8(string));
        }
        this.annotation.put12(91, 0);
        return new AnnotationWriter(this.symbolTable, false, this.annotation, null);
    }

    public void visitEnd() {
        if (this.numElementValuePairsOffset != -1) {
            byte[] byArray = this.annotation.data;
            byArray[this.numElementValuePairsOffset] = (byte)(this.numElementValuePairs >>> 8);
            byArray[this.numElementValuePairsOffset + 1] = (byte)this.numElementValuePairs;
        }
    }
}

