/*
 * Decompiled with CFR 0.152.
 */
package riotcmd;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdGeneral;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.util.FileManager;
import java.util.List;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.process.inf.InfFactory;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;

public class infer
extends CmdGeneral {
    static final ArgDecl argRDFS = new ArgDecl(true, "rdfs", new String[0]);
    private Model vocab;

    public static void main(String ... argv) {
        new infer(argv).mainRun();
    }

    protected infer(String[] argv) {
        super(argv);
        super.add(argRDFS);
    }

    @Override
    protected String getSummary() {
        return "infer --rdfs=vocab FILE ...";
    }

    @Override
    protected void processModulesAndArgs() {
        if (!this.contains(argRDFS)) {
            throw new CmdException("Required argument missing: --" + argRDFS.getKeyName());
        }
        String fn = this.getValue(argRDFS);
        this.vocab = FileManager.get().loadModel(fn);
    }

    @Override
    protected void exec() {
        StreamRDF sink = StreamRDFLib.writer(System.out);
        sink = InfFactory.inf(sink, this.vocab);
        List<String> files = this.getPositionalOrStdin();
        if (files.isEmpty()) {
            files.add("-");
        }
        for (String fn : files) {
            this.processFile(fn, sink);
        }
        IO.flush(System.out);
    }

    private void processFile(String filename, StreamRDF sink) {
        Lang lang;
        Lang lang2 = lang = filename.equals("-") ? RDFLanguages.NQUADS : RDFLanguages.filenameToLang(filename, RDFLanguages.NQUADS);
        if (filename.equals("-")) {
            RDFDataMgr.parse(sink, System.in, null, RDFLanguages.NQUADS, null);
        } else {
            RDFDataMgr.parse(sink, filename);
        }
    }

    @Override
    protected String getCommandName() {
        return "infer";
    }
}

