/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.transaction;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.ReadWrite;
import com.hp.hpl.jena.sparql.JenaTransactionException;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphTrackActive;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.tdb.StoreConnection;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.transaction.DatasetGraphTxn;
import com.hp.hpl.jena.tdb.transaction.SysTxnState;
import com.hp.hpl.jena.tdb.transaction.TDBTransactionException;
import com.hp.hpl.jena.update.GraphStore;
import org.apache.jena.atlas.lib.Sync;

public class DatasetGraphTransaction
extends DatasetGraphTrackActive
implements GraphStore,
Sync {
    private ThreadLocalTxn txn = new ThreadLocalTxn();
    private ThreadLocalBoolean inTransaction = new ThreadLocalBoolean();
    private final StoreConnection sConn;
    private boolean isClosed = false;

    public DatasetGraphTransaction(Location location) {
        this.sConn = StoreConnection.make(location);
    }

    public Location getLocation() {
        return this.sConn.getLocation();
    }

    public DatasetGraphTDB getDatasetGraphToQuery() {
        this.checkNotClosed();
        return this.get();
    }

    public DatasetGraphTDB getBaseDatasetGraph() {
        this.checkNotClosed();
        return this.sConn.getBaseDataset();
    }

    public DatasetGraphTDB get() {
        if (this.isInTransaction()) {
            DatasetGraphTxn dsgTxn = (DatasetGraphTxn)((Object)this.txn.get());
            if (dsgTxn == null) {
                throw new TDBTransactionException("In a transaction but no transactional DatasetGraph");
            }
            return dsgTxn.getView();
        }
        if (this.sConn.haveUsedInTransaction()) {
            throw new TDBTransactionException("Not in a transaction");
        }
        return this.sConn.getBaseDataset();
    }

    protected void checkActive() {
        this.checkNotClosed();
        if (this.sConn.haveUsedInTransaction() && !this.isInTransaction()) {
            throw new JenaTransactionException("Not in a transaction (" + this.getLocation() + ")");
        }
    }

    protected void checkNotActive() {
        this.checkNotClosed();
        if (this.sConn.haveUsedInTransaction() && this.isInTransaction()) {
            throw new JenaTransactionException("Currently in a transaction (" + this.getLocation() + ")");
        }
    }

    protected void checkNotClosed() {
        if (this.isClosed) {
            throw new JenaTransactionException("Already closed");
        }
    }

    public boolean isInTransaction() {
        this.checkNotClosed();
        return (Boolean)this.inTransaction.get();
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void syncIfNotTransactional() {
        if (!this.sConn.haveUsedInTransaction()) {
            this.sConn.getBaseDataset().sync();
        }
    }

    protected void _begin(ReadWrite readWrite) {
        this.checkNotClosed();
        DatasetGraphTxn dsgTxn = this.sConn.begin(readWrite);
        this.txn.set(dsgTxn);
        this.inTransaction.set(true);
    }

    protected void _commit() {
        this.checkNotClosed();
        ((DatasetGraphTxn)((Object)this.txn.get())).commit();
        this.inTransaction.set(false);
    }

    protected void _abort() {
        this.checkNotClosed();
        ((DatasetGraphTxn)((Object)this.txn.get())).abort();
        this.inTransaction.set(false);
    }

    protected void _end() {
        this.checkNotClosed();
        DatasetGraphTxn dsg = (DatasetGraphTxn)((Object)this.txn.get());
        if (dsg == null) {
            TDB.logInfo.warn("Transaction already ended");
            return;
        }
        ((DatasetGraphTxn)((Object)this.txn.get())).end();
        this.inTransaction.set(false);
        this.txn.set(null);
    }

    public String toString() {
        try {
            if (this.isInTransaction()) {
                return this.get().toString();
            }
            return this.getBaseDatasetGraph().toString();
        }
        catch (Throwable th) {
            return "DatasetGraphTransaction";
        }
    }

    protected void _close() {
        if (this.isClosed) {
            return;
        }
        if (!this.sConn.haveUsedInTransaction() && this.get() != null) {
            DatasetGraphTDB dsg = this.get();
            dsg.sync();
            dsg.close();
            StoreConnection.release(dsg.getLocation());
            this.isClosed = true;
            return;
        }
        if (this.isInTransaction()) {
            TDB.logInfo.warn("Attempt to close a DatasetGraphTransaction while a transaction is active - ignored close (" + this.getLocation() + ")");
            return;
        }
        this.isClosed = true;
        this.txn.remove();
        this.inTransaction.remove();
    }

    public Dataset toDataset() {
        return DatasetFactory.create((DatasetGraph)this.getDatasetGraphToQuery());
    }

    public Context getContext() {
        return this.getBaseDatasetGraph().getContext();
    }

    public SysTxnState getTransMgrState() {
        return this.sConn.getTransMgrState();
    }

    public void startRequest() {
    }

    public void finishRequest() {
    }

    public void sync() {
        if (!this.sConn.haveUsedInTransaction() && this.get() != null) {
            this.get().sync();
        }
    }

    static class ThreadLocalBoolean
    extends ThreadLocal<Boolean> {
        ThreadLocalBoolean() {
        }

        @Override
        protected Boolean initialValue() {
            return false;
        }
    }

    static class ThreadLocalTxn
    extends ThreadLocal<DatasetGraphTxn> {
        ThreadLocalTxn() {
        }

        @Override
        protected DatasetGraphTxn initialValue() {
            return null;
        }
    }
}

