/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.CollectPreconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableBiMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableSet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Maps;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.google.j2objc.annotations.RetainedWith;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class SingletonImmutableBiMap
extends ImmutableBiMap {
    final transient Object singleKey;
    final transient Object singleValue;
    @LazyInit
    @RetainedWith
    transient ImmutableBiMap inverse;

    SingletonImmutableBiMap(Object object, Object object2) {
        CollectPreconditions.checkEntryNotNull(object, object2);
        this.singleKey = object;
        this.singleValue = object2;
    }

    private SingletonImmutableBiMap(Object object, Object object2, ImmutableBiMap immutableBiMap) {
        this.singleKey = object;
        this.singleValue = object2;
        this.inverse = immutableBiMap;
    }

    @Override
    public Object get(@NullableDecl Object object) {
        return this.singleKey.equals(object) ? this.singleValue : null;
    }

    @Override
    public int size() {
        return 1;
    }

    public void forEach(BiConsumer biConsumer) {
        ((BiConsumer)Preconditions.checkNotNull(biConsumer)).accept(this.singleKey, this.singleValue);
    }

    @Override
    public boolean containsKey(@NullableDecl Object object) {
        return this.singleKey.equals(object);
    }

    @Override
    public boolean containsValue(@NullableDecl Object object) {
        return this.singleValue.equals(object);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    ImmutableSet createEntrySet() {
        return ImmutableSet.of(Maps.immutableEntry(this.singleKey, this.singleValue));
    }

    @Override
    ImmutableSet createKeySet() {
        return ImmutableSet.of(this.singleKey);
    }

    @Override
    public ImmutableBiMap inverse() {
        ImmutableBiMap immutableBiMap = this.inverse;
        if (immutableBiMap == null) {
            this.inverse = new SingletonImmutableBiMap(this.singleValue, this.singleKey, this);
            return this.inverse;
        }
        return immutableBiMap;
    }
}

