/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.core.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public class HostUtil {
    public static String canonicalName(String hostName) throws UnknownHostException {
        InetAddress host = InetAddress.getByName(hostName);
        return HostUtil.reverseLookup(host.getAddress());
    }

    public static String reverseLookup(byte[] address) throws UnknownHostException {
        InetAddress lookup = InetAddress.getByAddress(address);
        if (lookup == null) {
            return null;
        }
        return lookup.getCanonicalHostName();
    }

    public static String reverseLookup(String dottedQuadAddress) throws UnknownHostException {
        byte[] addr = new byte[4];
        StringTokenizer st = new StringTokenizer(dottedQuadAddress, ".", false);
        int i = 0;
        while (st.hasMoreTokens()) {
            try {
                addr[i++] = Byte.parseByte(st.nextToken());
            }
            catch (NumberFormatException nfx) {
                return HostUtil.canonicalName(dottedQuadAddress);
            }
        }
        return HostUtil.reverseLookup(addr);
    }
}

