/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swing;

import java.awt.Image;
import java.awt.image.BufferedImage;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.util.Configuration;
import org.xhtmlrenderer.util.ImageUtil;

public abstract class AWTFSImage
implements FSImage {
    private static final FSImage NULL_FS_IMAGE = new NullImage();

    public static FSImage createLegacyImage(Image img) {
        return new OldAWTFSImage(img);
    }

    public static FSImage createImage(Image img) {
        boolean useBufferedImage = Configuration.isTrue("xr.image.buffered", false);
        if (img == null) {
            return NULL_FS_IMAGE;
        }
        if (useBufferedImage) {
            return new NewAWTFSImage(img);
        }
        return new OldAWTFSImage(img);
    }

    protected AWTFSImage() {
    }

    public abstract Image getImage();

    private static class NullImage
    extends AWTFSImage {
        private static final Image EMPTY_IMAGE = ImageUtil.createTransparentImage(1, 1);

        private NullImage() {
        }

        public int getWidth() {
            return 0;
        }

        public int getHeight() {
            return 0;
        }

        public void scale(int width, int height) {
        }

        public Image getImage() {
            return EMPTY_IMAGE;
        }
    }

    static class NewAWTFSImage
    extends AWTFSImage {
        private Image img;

        public NewAWTFSImage(Image img) {
            this.img = img;
        }

        public int getWidth() {
            return this.img.getWidth(null);
        }

        public int getHeight() {
            return this.img.getHeight(null);
        }

        public Image getImage() {
            return this.img;
        }

        public void scale(int width, int height) {
            this.img = this.img.getScaledInstance(width, height, 1);
        }
    }

    static class OldAWTFSImage
    extends AWTFSImage {
        private Image img;

        public OldAWTFSImage(Image img) {
            if (img instanceof BufferedImage) {
                img = img.getScaledInstance(img.getWidth(null), img.getHeight(null), 2);
            }
            this.img = img;
        }

        public int getWidth() {
            return this.img.getWidth(null);
        }

        public int getHeight() {
            return this.img.getHeight(null);
        }

        public Image getImage() {
            return this.img;
        }

        public void scale(int width, int height) {
            this.img = this.img.getScaledInstance(width, height, 2);
        }
    }
}

