/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.osti_elink;

import edu.ucsb.nceas.osti_elink.OSTIElinkErrorAgent;
import edu.ucsb.nceas.osti_elink.OSTIElinkException;
import edu.ucsb.nceas.osti_elink.OSTIElinkService;
import edu.ucsb.nceas.osti_elink.OSTIElinkServiceRequest;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OSTIElinkClient {
    private String USERNAME = "";
    private String PASSWORD = "";
    private OSTIElinkErrorAgent errorAgent = null;
    private OSTIElinkService service = null;
    private ExecutorService executor = null;
    protected static Log log = LogFactory.getLog(OSTIElinkClient.class);

    public OSTIElinkClient(String username, String password, String baseURL, OSTIElinkErrorAgent errorAgent) {
        this.service = new OSTIElinkService(username, password, baseURL);
        this.errorAgent = errorAgent;
        this.startExecutorLoop();
    }

    public void setMetadata(String identifier, String metadata) throws InterruptedException {
        OSTIElinkServiceRequest request = new OSTIElinkServiceRequest(this.service, 1, identifier, this.errorAgent, metadata);
        this.executor.execute(request);
    }

    public String mintIdentifier(String siteCode) throws OSTIElinkException {
        String identifier = null;
        try {
            identifier = this.service.mintIdentifier(siteCode);
        }
        catch (OSTIElinkException e) {
            if (this.errorAgent != null) {
                this.errorAgent.notify(e);
            }
            throw e;
        }
        return identifier;
    }

    public String getMetadata(String identifier) throws OSTIElinkException {
        return this.service.getMetadata(identifier);
    }

    public String getStatus(String identifier) throws OSTIElinkException {
        return this.service.getStatus(identifier);
    }

    private void startExecutorLoop() {
        Runtime runtime = Runtime.getRuntime();
        int numCores = runtime.availableProcessors();
        log.debug((Object)("OSTIElinkClient.startExecutorLoop - Number of cores available: " + numCores));
        this.executor = Executors.newFixedThreadPool(numCores);
    }

    public void shutdown() {
        log.debug((Object)"Shutting down executor...");
        this.executor.shutdown();
        while (!this.executor.isTerminated()) {
        }
    }
}

