/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.speedbagit;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.speedbagit.SpeedFile;
import org.dataone.speedbagit.SpeedStream;

public class SpeedBagIt {
    private static final Log logger = LogFactory.getLog(SpeedBagIt.class);
    private Properties properties;
    public double version;
    public Map<String, String> tagManifestFile;
    public Map<String, String> dataManifestFile;
    public String checksumAlgorithm;
    public Map<String, String> bagitMetadata;
    private List<SpeedFile> dataFiles;
    private List<SpeedFile> tagFiles;
    private static ExecutorService executor = null;

    public SpeedBagIt(double version, String checksumAlgorithm, Map<String, String> bagitMetadata) throws IOException {
        this.version = version;
        this.checksumAlgorithm = checksumAlgorithm;
        this.dataFiles = new ArrayList<SpeedFile>();
        this.tagFiles = new ArrayList<SpeedFile>();
        this.bagitMetadata = bagitMetadata;
        this.dataManifestFile = new HashMap<String, String>();
        this.tagManifestFile = new HashMap<String, String>();
        this.properties = new Properties();
        this.properties.load(Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream("speed-bagit.properties")));
    }

    public SpeedBagIt(double version, String checksumAlgorithm) throws IOException {
        this.version = version;
        this.checksumAlgorithm = checksumAlgorithm;
        this.dataFiles = new ArrayList<SpeedFile>();
        this.tagFiles = new ArrayList<SpeedFile>();
        this.bagitMetadata = new HashMap<String, String>();
        this.dataManifestFile = new HashMap<String, String>();
        this.tagManifestFile = new HashMap<String, String>();
        this.properties = new Properties();
        this.properties.load(Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream("speed-bagit.properties")));
    }

    public void addFile(InputStream file, String bagPath, MessageDigest checksum, boolean isTagFile) {
        logger.debug((Object)String.format("Adding %s to the bag", bagPath));
        SpeedFile newFile = new SpeedFile(new SpeedStream(file, checksum), bagPath, isTagFile);
        if (isTagFile) {
            this.tagFiles.add(newFile);
        } else {
            this.dataFiles.add(newFile);
        }
    }

    public void addFile(InputStream file, String bagPath, boolean isTagFile) throws NoSuchAlgorithmException {
        logger.debug((Object)String.format("Adding %s to the bag", bagPath));
        MessageDigest newDigest = MessageDigest.getInstance(this.checksumAlgorithm);
        SpeedFile newFile = new SpeedFile(new SpeedStream(file, newDigest), bagPath, isTagFile);
        if (isTagFile) {
            this.tagFiles.add(newFile);
        } else {
            this.dataFiles.add(newFile);
        }
    }

    public String generateBagitTxt() {
        logger.debug((Object)"Creating the bagit.txt file");
        String bagitFile = "";
        for (Map.Entry<String, String> entry : this.bagitMetadata.entrySet()) {
            if (bagitFile != null) {
                bagitFile = String.format("%s%s: %s\n", bagitFile, entry.getKey(), entry.getValue());
                continue;
            }
            bagitFile = String.format("%s: %s\n", entry.getKey(), entry.getValue());
        }
        String tagFileversion = this.properties.getProperty("tag.file.version");
        String tagFileCharacterEncodingName = this.properties.getProperty("tag.file.character.encoding.name");
        String tagFileCharacterEncodingValue = this.properties.getProperty("tag.file.character.encoding.value");
        bagitFile = String.format("%s%s: %s\n", bagitFile, tagFileversion, this.version);
        bagitFile = String.format("%s%s: %s\n", bagitFile, tagFileCharacterEncodingName, tagFileCharacterEncodingValue);
        return bagitFile;
    }

    public static String formatSize(long size) {
        if (size < 1024L) {
            return size + " B";
        }
        int z = (63 - Long.numberOfLeadingZeros(size)) / 10;
        return String.format("%.1f %sB", (double)size / (double)(1L << z * 10), Character.valueOf(" KMGTPE".charAt(z)));
    }

    public String generateBagInfoTxt(String payloadOxum, int bagSize) {
        logger.debug((Object)"Generating bag-info.txt");
        LocalDateTime dateTime = LocalDateTime.now();
        DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd", Locale.ENGLISH);
        String bagInfoDateKey = this.properties.getProperty("bag.info.date");
        String bagInfo = String.format("%s: %s\n", bagInfoDateKey, dateFormat.format(dateTime));
        String bagInfoPayloadOxum = this.properties.getProperty("bag.info.payloadOxum");
        bagInfo = String.format("%s%s: %s\n", bagInfo, bagInfoPayloadOxum, payloadOxum);
        String bagInfoBagSize = this.properties.getProperty("bag.info.bagSize");
        bagInfo = String.format("%s%s: %s\n", bagInfo, bagInfoBagSize, SpeedBagIt.formatSize(bagSize));
        return bagInfo;
    }

    public void writeToTagManifest(String path, String checksum) {
        logger.debug((Object)String.format("Writing line to the tag-manifest %s %s", path, checksum));
        this.tagManifestFile.put(checksum, path);
    }

    public void writeToDataManifest(String path, String checksum) {
        logger.debug((Object)String.format("Writing line to the data manifest %s %s", path, checksum));
        this.dataManifestFile.put(checksum, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void streamFile(ZipOutputStream zos, SpeedFile streamingFile) throws IOException {
        try {
            ZipEntry entry = new ZipEntry(streamingFile.getPath());
            zos.putNextEntry(entry);
            SpeedStream fileStream = streamingFile.getStream();
            IOUtils.copy((InputStream)fileStream, (OutputStream)zos);
        }
        finally {
            zos.closeEntry();
        }
    }

    public InputStream stream() throws IOException, NoSuchAlgorithmException {
        PipedOutputStream ps = new PipedOutputStream();
        PipedInputStream is = new PipedInputStream(ps);
        final ZipOutputStream zos = new ZipOutputStream(ps);
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    String timeStamp = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss").format(new Date());
                    logger.info((Object)String.format("Streaming bag at %s", timeStamp));
                    int totalSize = 0;
                    for (SpeedFile streamingFile : SpeedBagIt.this.dataFiles) {
                        try {
                            SpeedBagIt.this.streamFile(zos, streamingFile);
                            String checksum = new String(streamingFile.getStream().getChecksum());
                            SpeedBagIt.this.writeToDataManifest(streamingFile.getPath(), checksum);
                            totalSize += streamingFile.getStream().getSize();
                        }
                        finally {
                            streamingFile.getStream().close();
                        }
                    }
                    String payloadOxum = String.format("%s.%s", totalSize, SpeedBagIt.this.dataFiles.size());
                    ByteArrayInputStream bagTextStream = new ByteArrayInputStream(SpeedBagIt.this.generateBagitTxt().getBytes(StandardCharsets.UTF_8));
                    String bagitFileName = SpeedBagIt.this.properties.getProperty("bagit.file.name");
                    SpeedBagIt.this.addFile(bagTextStream, bagitFileName, MessageDigest.getInstance(SpeedBagIt.this.checksumAlgorithm), true);
                    String bagInfoFile = SpeedBagIt.this.generateBagInfoTxt(payloadOxum, totalSize);
                    ByteArrayInputStream fileStream = new ByteArrayInputStream(bagInfoFile.getBytes(StandardCharsets.UTF_8));
                    String bagitInfoFileName = SpeedBagIt.this.properties.getProperty("bag.info.file.name");
                    SpeedBagIt.this.addFile(fileStream, bagitInfoFileName, MessageDigest.getInstance(SpeedBagIt.this.checksumAlgorithm), true);
                    String sanitizedChecksum = SpeedBagIt.this.checksumAlgorithm.toLowerCase();
                    sanitizedChecksum = sanitizedChecksum.replaceAll("[^A-Za-z0-9]", "");
                    String dataManifest = SpeedBagIt.bagFileToString(SpeedBagIt.this.dataManifestFile);
                    String fileName = String.format("manifest-%s.txt", sanitizedChecksum);
                    fileStream = new ByteArrayInputStream(dataManifest.getBytes(StandardCharsets.UTF_8));
                    SpeedBagIt.this.addFile(fileStream, fileName, MessageDigest.getInstance(SpeedBagIt.this.checksumAlgorithm), true);
                    for (SpeedFile streamingFile : SpeedBagIt.this.tagFiles) {
                        try {
                            SpeedBagIt.this.streamFile(zos, streamingFile);
                            String checksum = streamingFile.getStream().getChecksum();
                            SpeedBagIt.this.writeToTagManifest(streamingFile.getPath(), checksum);
                        }
                        finally {
                            streamingFile.getStream().close();
                        }
                    }
                    String tagMannifest = SpeedBagIt.bagFileToString(SpeedBagIt.this.tagManifestFile);
                    fileStream = new ByteArrayInputStream(tagMannifest.getBytes(StandardCharsets.UTF_8));
                    fileName = String.format("tagmanifest-%s.txt", sanitizedChecksum);
                    SpeedFile tagManifestStreamFile = new SpeedFile(new SpeedStream(fileStream, MessageDigest.getInstance(SpeedBagIt.this.checksumAlgorithm)), fileName, true);
                    try {
                        SpeedBagIt.this.streamFile(zos, tagManifestStreamFile);
                    }
                    finally {
                        tagManifestStreamFile.getStream().close();
                    }
                    zos.close();
                    timeStamp = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss").format(new Date());
                    logger.info((Object)String.format("Finished streaming bag at %s", timeStamp));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return is;
    }

    public int getPayloadFileCount() {
        return this.dataFiles.size();
    }

    public List<SpeedFile> getTagFiles() {
        return this.tagFiles;
    }

    public List<SpeedFile> getDataFiles() {
        return this.dataFiles;
    }

    public static String bagFileToString(Map<String, String> mapFile) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> e : mapFile.entrySet()) {
            String key = e.getKey();
            String value = e.getValue();
            builder.append(key);
            builder.append(' ');
            builder.append(value);
            builder.append(System.getProperty("line.separator"));
        }
        return builder.toString();
    }

    static {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        int nThreads = availableProcessors * 1;
        --nThreads;
        nThreads = Math.max(1, nThreads);
        executor = Executors.newFixedThreadPool(nThreads);
    }
}

