/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.speedbagit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import org.apache.commons.io.IOUtils;
import org.dataone.speedbagit.SpeedBagException;
import org.dataone.speedbagit.SpeedBagIt;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class ProfilingTest {
    @Test
    @Disabled
    public void testLargeFiles() throws IOException, NoSuchAlgorithmException, SpeedBagException {
        ProfilingTest.GenerateFiles("largeFiles/", 100, 1000000000L);
        ProfilingTest.CreateBag("largeFiles/", "./bagged_data.zip");
    }

    @Test
    @Disabled
    public void testSmallFiles() throws IOException, NoSuchAlgorithmException, SpeedBagException {
        ProfilingTest.GenerateFiles("smallFiles/", 5000, 1000L);
        ProfilingTest.CreateBag("smallFiles/", "./bagged_data.zip");
    }

    public static void GenerateFiles(String targetDirectory, int fileCount, long targetSize) throws FileNotFoundException {
        File directory = new File(targetDirectory);
        if (!directory.exists()) {
            directory.mkdir();
        }
        long chunkSize = (long)((double)targetSize * 0.05);
        Random rd = new Random();
        byte[] randomData = new byte[(int)chunkSize];
        rd.nextBytes(randomData);
        System.out.println(randomData.length);
        for (int filesWritten = 0; filesWritten < fileCount; ++filesWritten) {
            File dataFile = new File(targetDirectory + "/test_file" + filesWritten);
            try (FileOutputStream stream = new FileOutputStream(dataFile);){
                for (long bytesWritten = 0L; bytesWritten < targetSize; bytesWritten += (long)randomData.length) {
                    System.out.println(bytesWritten);
                    System.out.println(targetSize);
                    stream.write(randomData);
                }
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void CreateBag(String PayloadPath, String bagPath) throws IOException, NoSuchAlgorithmException, SpeedBagException {
        SpeedBagIt bag = new SpeedBagIt(1.0, "MD5");
        File dataDirectory = new File(PayloadPath);
        File[] directoryListing = dataDirectory.listFiles();
        if (directoryListing != null) {
            for (File dataFile : directoryListing) {
                String filePath = "data/" + dataFile.getName();
                System.out.println(bagPath);
                bag.addFile((InputStream)new FileInputStream(dataFile), filePath, MessageDigest.getInstance("MD5"), false);
            }
        }
        Path bagFilePath = Files.createFile(Paths.get(bagPath, new String[0]), new FileAttribute[0]);
        FileOutputStream fos = new FileOutputStream(bagFilePath.toString());
        InputStream bagStream = bag.stream();
        IOUtils.copy((InputStream)bagStream, (OutputStream)fos);
    }
}

