/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.speedbagit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.dataone.speedbagit.SpeedStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SpeedStreamTest {
    @Test
    public void testCtor() throws NoSuchAlgorithmException, IOException {
        String testData = "12345, 345rfdew, 45tgfdr";
        ByteArrayInputStream testDataStream = new ByteArrayInputStream(testData.getBytes());
        MessageDigest targetDigest = MessageDigest.getInstance("MD5");
        SpeedStream speedStream = new SpeedStream((InputStream)testDataStream, targetDigest);
        Assertions.assertEquals((int)speedStream.getSize(), (int)0);
    }

    @Test
    public void testSingleByteRead() throws NoSuchAlgorithmException, IOException {
        int length;
        String testData = "12345, 345rfdew, 45tgfdr";
        String expectedSHA1 = "2fe482afad4e73addf3cb3823ff9b83144763bf2";
        ByteArrayInputStream testDataStream = new ByteArrayInputStream(testData.getBytes());
        MessageDigest targetDigest = MessageDigest.getInstance("SHA-1");
        SpeedStream speedStream = new SpeedStream((InputStream)testDataStream, targetDigest);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = speedStream.read()) != -1) {
            result.write(buffer, 0, length);
        }
        Assertions.assertEquals((Object)expectedSHA1, (Object)speedStream.getChecksum());
        Assertions.assertEquals((int)testData.length(), (int)speedStream.getSize());
    }

    @Test
    public void testChecksummingBufferedRead() throws NoSuchAlgorithmException, IOException {
        int length;
        String testData = "12345, 345rfdew, 45tgfdr";
        String expectedSHA1 = "2fe482afad4e73addf3cb3823ff9b83144763bf2";
        ByteArrayInputStream testDataStream = new ByteArrayInputStream(testData.getBytes());
        MessageDigest targetDigest = MessageDigest.getInstance("SHA-1");
        SpeedStream speedStream = new SpeedStream((InputStream)testDataStream, targetDigest);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = speedStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        Assertions.assertEquals((Object)expectedSHA1, (Object)speedStream.getChecksum());
        Assertions.assertEquals((int)testData.length(), (int)speedStream.getSize());
        Assertions.assertEquals((int)result.toString().length(), (int)testData.length());
    }
}

