/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.resourcemap;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Set;
import org.dataone.cn.hazelcast.HazelcastClientInstance;
import org.dataone.cn.indexer.resourcemap.ResourceMap;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.configuration.Settings;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.SystemMetadata;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ResourceEntry {
    private Element entry = null;
    private String identifier = null;
    private Set<String> resourceMaps = new HashSet<String>();
    private Set<String> documents = new HashSet<String>();
    private Set<String> isDocumentedBy = new HashSet<String>();
    private String about = null;
    private ResourceMap parentMap = null;
    private HazelcastInstance hzClient;
    private static final String HZ_SYSTEM_METADATA = Settings.getConfiguration().getString("dataone.hazelcast.systemMetadata");
    private IMap<Identifier, SystemMetadata> systemMetadata;

    public ResourceEntry(Element entry, ResourceMap parentMap) {
        this.getResourceMaps().add(parentMap.getIdentifier());
        this.setParentMap(parentMap);
        this.entry = entry;
        this.initEntry();
    }

    private void initEntry() {
        this.startHazelClient();
        this.setAbout(this.entry.getAttributeNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about"));
        this.setIdentifier(this.entry.getElementsByTagNameNS("http://purl.org/dc/terms/", "identifier").item(0).getTextContent());
        NodeList nlDocuments = this.entry.getElementsByTagNameNS("http://purl.org/spar/cito/", "documents");
        this.documents = this.parseDocuments(nlDocuments);
        NodeList nlIsDocumentedBy = this.entry.getElementsByTagNameNS("http://purl.org/spar/cito/", "isDocumentedBy");
        this.isDocumentedBy = this.parseIsDocumentedBy(nlIsDocumentedBy);
    }

    private Set<String> parseIsDocumentedBy(NodeList nlIsDocumentedBy) {
        HashSet<String> isDocumentedByStrings = new HashSet<String>();
        for (int i = 0; i < nlIsDocumentedBy.getLength(); ++i) {
            Element isDocumentedByElement = (Element)nlIsDocumentedBy.item(i);
            String isDocumentedByString = isDocumentedByElement.getAttributeNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource");
            String id = this.parentMap.getIdentifierFromResource(isDocumentedByString);
            Identifier pid = new Identifier();
            pid.setValue(id);
            SystemMetadata smd = (SystemMetadata)this.systemMetadata.get((Object)pid);
            if (!SolrDoc.visibleInIndex(smd)) continue;
            isDocumentedByStrings.add(id);
        }
        return isDocumentedByStrings;
    }

    private Set<String> parseDocuments(NodeList nlDocuments) {
        HashSet<String> documetsStrings = new HashSet<String>();
        for (int i = 0; i < nlDocuments.getLength(); ++i) {
            Element documentsElement = (Element)nlDocuments.item(i);
            String resource = documentsElement.getAttributeNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource");
            String id = this.parentMap.getIdentifierFromResource(resource);
            Identifier pid = new Identifier();
            pid.setValue(id);
            SystemMetadata smd = (SystemMetadata)this.systemMetadata.get((Object)pid);
            if (!SolrDoc.visibleInIndex(smd)) continue;
            documetsStrings.add(id);
        }
        return documetsStrings;
    }

    public Element getEntry() {
        return this.entry;
    }

    public void setEntry(Element entry) {
        this.entry = entry;
    }

    public Set<String> getResourceMaps() {
        if (this.resourceMaps == null) {
            this.resourceMaps = new HashSet<String>();
        }
        return this.resourceMaps;
    }

    public void setResourceMaps(Set<String> resourceMaps) {
        this.resourceMaps = resourceMaps;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public Set<String> getDocuments() {
        return this.documents;
    }

    public void setDocuments(Set<String> documents) {
        this.documents = documents;
    }

    public Set<String> getDocumentedBy() {
        return this.isDocumentedBy;
    }

    public void setDocumentedBy(Set<String> documentedBy) {
        this.isDocumentedBy = documentedBy;
    }

    public String getAbout() {
        return this.about;
    }

    public void setAbout(String about) {
        this.about = about;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        sw.write("\tRESOURCE MAP ENTITY: ");
        sw.append(this.identifier);
        sw.write("\n");
        sw.write("\t\tDocuments: ");
        sw.write("\n");
        for (String documentString : this.documents) {
            sw.write("\t\t\t");
            sw.append(documentString);
            sw.write("\n");
        }
        sw.write("\t\tisDocumentedByString: ");
        sw.write("\n");
        for (String isDocumentedByString : this.isDocumentedBy) {
            sw.write("\t\t\t");
            sw.append(isDocumentedByString);
            sw.write("\n");
        }
        sw.write("\t\tResource Maps: ");
        sw.write("\n");
        for (String resourceMap : this.resourceMaps) {
            sw.write("\t\t\t");
            sw.append(resourceMap);
            sw.write("\n");
        }
        return sw.toString();
    }

    public ResourceMap getParentMap() {
        return this.parentMap;
    }

    public void setParentMap(ResourceMap parentMap) {
        this.parentMap = parentMap;
    }

    private void startHazelClient() {
        if (this.hzClient == null) {
            this.hzClient = HazelcastClientInstance.getHazelcastClient();
            this.systemMetadata = this.hzClient.getMap(HZ_SYSTEM_METADATA);
        }
    }
}

