/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.bookkeeper.resources;

import com.codahale.metrics.annotation.Timed;
import io.dropwizard.auth.AuthenticationException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.security.PermitAll;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.bookkeeper.api.Customer;
import org.dataone.bookkeeper.api.Quota;
import org.dataone.bookkeeper.api.QuotaList;
import org.dataone.bookkeeper.jdbi.QuotaStore;
import org.dataone.bookkeeper.resources.BaseResource;
import org.dataone.bookkeeper.security.DataONEAuthHelper;
import org.jdbi.v3.core.Jdbi;

@Timed
@Path(value="/quotas")
@Produces(value={"application/json"})
public class QuotasResource
extends BaseResource {
    private final Log log = LogFactory.getLog(QuotasResource.class);
    private final QuotaStore quotaStore;
    private final DataONEAuthHelper dataoneAuthHelper;

    public QuotasResource(Jdbi database, DataONEAuthHelper dataoneAuthHelper) {
        this.quotaStore = (QuotaStore)database.onDemand(QuotaStore.class);
        this.dataoneAuthHelper = dataoneAuthHelper;
    }

    @Timed
    @GET
    @PermitAll
    @Produces(value={"application/json"})
    public QuotaList listQuotas(@Context SecurityContext context, @QueryParam(value="start") @DefaultValue(value="0") Integer start, @QueryParam(value="count") @DefaultValue(value="1000") Integer count, @QueryParam(value="quotaType") String quotaType, @QueryParam(value="subject") Set<String> subjects, @QueryParam(value="requestor") String requestor) throws WebApplicationException {
        Customer caller = (Customer)context.getUserPrincipal();
        boolean isAdmin = this.dataoneAuthHelper.isAdmin(caller.getSubject());
        ArrayList<String> approvedSubjects = new ArrayList<String>();
        Boolean isProxy = isAdmin && requestor != null;
        if (requestor != null) {
            if (isAdmin) {
                try {
                    caller = this.dataoneAuthHelper.createCustomerFromSubject(requestor);
                }
                catch (AuthenticationException dae) {
                    String message = "The requested quotas couldn't be listed: " + dae.getMessage();
                    throw new WebApplicationException(message, Response.Status.BAD_REQUEST);
                }
            } else {
                throw new WebApplicationException(caller.getSubject() + " does not have admin privilege needed to set 'requestor'. ", Response.Status.FORBIDDEN);
            }
        }
        if (subjects != null && subjects.size() > 0) {
            if (!isAdmin || isProxy.booleanValue()) {
                Set<String> associatedSubjects = this.dataoneAuthHelper.filterByAssociatedSubjects(caller, subjects);
                if (associatedSubjects.size() > 0) {
                    approvedSubjects.addAll(associatedSubjects);
                }
                if (approvedSubjects.size() == 0) {
                    throw new WebApplicationException("The requested subjects don't exist or requestor doesn't have privilege to view them.", Response.Status.FORBIDDEN);
                }
            } else {
                approvedSubjects.addAll(subjects);
            }
        } else if ((!isAdmin || isProxy.booleanValue()) && approvedSubjects.size() == 0) {
            approvedSubjects = new ArrayList<String>(this.dataoneAuthHelper.getAssociatedSubjects(caller));
        }
        List<Quota> quotas = quotaType != null ? (approvedSubjects.size() > 0 ? this.quotaStore.findQuotasByNameAndSubjects(quotaType, approvedSubjects) : this.quotaStore.findQuotasByType(quotaType)) : (approvedSubjects.size() > 0 ? this.quotaStore.findQuotasBySubjects(approvedSubjects) : this.quotaStore.listQuotas());
        if (quotas == null || quotas.size() == 0) {
            if (!isAdmin || isProxy.booleanValue()) {
                throw new WebApplicationException("The requested quotas were not found or requestor does not have privilege to view them.", Response.Status.NOT_FOUND);
            }
            throw new WebApplicationException("The requested quotas were not found.", Response.Status.NOT_FOUND);
        }
        return new QuotaList(quotas);
    }

    @Timed
    @POST
    @PermitAll
    @Consumes(value={"application/json"})
    public Quota create(@Context SecurityContext context, @NotNull @Valid Quota quota) throws WebApplicationException {
        Customer caller = (Customer)context.getUserPrincipal();
        if (!this.dataoneAuthHelper.isBookkeeperAdmin(caller.getSubject())) {
            throw new WebApplicationException("Bookkeepr admin privilege is required to create a quota, " + caller.getSubject() + " is not authorized.", Response.Status.FORBIDDEN);
        }
        try {
            Integer id = this.quotaStore.insert(quota);
            quota = this.quotaStore.getQuota(id);
        }
        catch (Exception e) {
            String message = "Couldn't insert the quota: " + e.getMessage();
            throw new WebApplicationException(message, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return quota;
    }

    @Timed
    @GET
    @PermitAll
    @Produces(value={"application/json"})
    @Path(value="{quotaId}")
    public Quota retrieve(@Context SecurityContext context, @PathParam(value="quotaId") @NotNull Integer quotaId) throws WebApplicationException {
        Customer caller = (Customer)context.getUserPrincipal();
        try {
            Quota quota = this.quotaStore.getQuota(quotaId);
            if (quota == null) {
                throw new WebApplicationException("The quota was not found.", Response.Status.NOT_FOUND);
            }
            if (this.dataoneAuthHelper.isAdmin(caller.getSubject())) {
                return quota;
            }
            String quotaSubject = quota.getSubject();
            HashSet<String> subjects = new HashSet<String>();
            subjects.add(quotaSubject);
            Set<String> associatedSubjects = this.dataoneAuthHelper.filterByAssociatedSubjects(caller, subjects);
            if (associatedSubjects.size() > 0) {
                return quota;
            }
            throw new WebApplicationException(caller.getSubject() + " is not associated with this quota.", Response.Status.FORBIDDEN);
        }
        catch (Exception e) {
            String message = "The requested quota could not be retrieved: " + e.getMessage();
            throw new WebApplicationException(message, Response.Status.NOT_FOUND);
        }
    }

    @Timed
    @PUT
    @PermitAll
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{quotaId}")
    public Quota update(@Context SecurityContext context, @NotNull @Valid Quota quota) throws WebApplicationException {
        Quota updatedQuota;
        Customer caller = (Customer)context.getUserPrincipal();
        if (!this.dataoneAuthHelper.isBookkeeperAdmin(caller.getSubject())) {
            throw new WebApplicationException("Bookkeeper admin privilege is required to update a quota, " + caller.getSubject() + " is not authorized.", Response.Status.FORBIDDEN);
        }
        try {
            updatedQuota = this.quotaStore.update(quota);
        }
        catch (Exception e) {
            String message = "Couldn't update the quota: " + e.getMessage();
            throw new WebApplicationException(message, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return updatedQuota;
    }

    @Timed
    @DELETE
    @PermitAll
    @Path(value="{quotaId}")
    public Response delete(@Context SecurityContext context, @PathParam(value="quotaId") @Valid Integer quotaId) throws WebApplicationException {
        Customer caller = (Customer)context.getUserPrincipal();
        if (!this.dataoneAuthHelper.isBookkeeperAdmin(caller.getSubject())) {
            throw new WebApplicationException("Bookkeeper admin privilege is required to delete a quota, " + caller.getSubject() + " is not authorized.", Response.Status.FORBIDDEN);
        }
        String message = "The quotaId cannot be null.";
        if (quotaId == null) {
            throw new WebApplicationException(message, Response.Status.BAD_REQUEST);
        }
        try {
            this.quotaStore.delete(quotaId);
        }
        catch (Exception e) {
            message = "Deleting the quota with id " + quotaId + " failed: " + e.getMessage();
            this.log.error((Object)message);
            e.printStackTrace();
            throw e;
        }
        return Response.ok().build();
    }
}

