/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.parser;

import com.hp.hpl.jena.query.Dataset;
import java.util.ArrayList;
import java.util.List;
import org.dataone.cn.indexer.convert.IConverter;
import org.dataone.cn.indexer.parser.ISolrDatasetField;
import org.dataone.cn.indexer.parser.utility.ElementCombiner;
import org.dataone.cn.indexer.parser.utility.LogicalOrPostProcessor;
import org.dataone.cn.indexer.solrhttp.SolrElementField;

public class DerivedSolrField
implements ISolrDatasetField {
    private ElementCombiner base;
    private LogicalOrPostProcessor orProcessor = new LogicalOrPostProcessor();
    protected boolean multivalue = false;
    protected String name = null;
    protected IConverter converter = null;

    public DerivedSolrField(String name) {
        this.name = name;
    }

    @Override
    public ElementCombiner getBase() {
        return this.base;
    }

    @Override
    public void setBase(ElementCombiner base) {
        this.base = base;
    }

    @Override
    public List<SolrElementField> getFields(Dataset dataset) {
        ArrayList<SolrElementField> fields = new ArrayList<SolrElementField>();
        if (this.base != null) {
            List<String> resultValues = this.base.getElementValues(dataset, this.isMultivalue());
            for (String value : resultValues) {
                if (this.orProcessor != null) {
                    value = this.orProcessor.process(value);
                }
                if (this.getConverter() != null) {
                    value = this.getConverter().convert(value);
                }
                if (value != null && !value.isEmpty()) {
                    fields.add(new SolrElementField(this.name, value));
                }
                if (this.isMultivalue()) continue;
                break;
            }
        }
        return fields;
    }

    @Override
    public List<SolrElementField> getFields(byte[] data, String identifier) throws Exception {
        return null;
    }

    public boolean isMultivalue() {
        return this.multivalue;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMultivalue(boolean multivalue) {
        this.multivalue = multivalue;
    }

    public IConverter getConverter() {
        return this.converter;
    }

    public void setConverter(IConverter converter) {
        this.converter = converter;
    }
}

