/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.dataone.cn.indexer.XMLNamespaceConfig;
import org.dataone.cn.indexer.parser.SolrField;
import org.dataone.cn.indexer.solrhttp.SolrElementField;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SolrFieldResourceMap
extends SolrField {
    private DocumentBuilderFactory documentBuilderFactory = null;
    private static DocumentBuilder builder = null;
    private XPathFactory xpathFactory = XPathFactory.newInstance();
    private XPath xpathEval = this.xpathFactory.newXPath();
    private XMLNamespaceConfig xmlNamespaceConfig = null;
    private XPathExpression resourceExpression = null;
    String resourceMapRegexMatch = null;
    private String objectFormatXPath = null;
    private String baseUrl = null;
    private String resourceValueMatch = null;

    public SolrFieldResourceMap(String name, String xpath, String resourceMapXpath, boolean multivalue, XMLNamespaceConfig xmlNamespaceConfig) throws ParserConfigurationException {
        super(name, xpath, multivalue);
        this.xpathEval.setNamespaceContext(xmlNamespaceConfig);
    }

    @Override
    public void initExpression(XPath xpathObject) {
        super.initExpression(xpathObject);
    }

    private boolean hasResourceMap(String value) {
        return value.matches(this.getResourceValueMatch());
    }

    @Override
    public List<SolrElementField> getFields(Document doc, String identifier) throws XPathExpressionException, IOException, SAXException, ParserConfigurationException {
        String value = (String)this.getxPathExpression().evaluate(doc, XPathConstants.STRING);
        if (this.hasResourceMap(value)) {
            String uri = this.getBaseUrl() + value;
            DefaultHttpClient client = new DefaultHttpClient();
            HttpGet request = new HttpGet(uri);
            HttpResponse response = client.execute((HttpUriRequest)request);
            HttpEntity responseEntity = response.getEntity();
            InputStream responseInputStream = responseEntity.getContent();
            Document resourceDocument = this.getBuilder().parse(responseInputStream);
            return this.processField(resourceDocument, this.resourceExpression, this.getName(), null, true, false);
        }
        return new ArrayList<SolrElementField>();
    }

    public String getObjectFormatXPath() {
        return this.objectFormatXPath;
    }

    public void setObjectFormatXPath(String objectFormatXPath) {
        this.objectFormatXPath = objectFormatXPath;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    private DocumentBuilder getBuilder() throws ParserConfigurationException {
        if (builder == null) {
            this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
            this.documentBuilderFactory.setNamespaceAware(true);
            builder = this.documentBuilderFactory.newDocumentBuilder();
        }
        return builder;
    }

    public String getResourceValueMatch() {
        return this.resourceValueMatch;
    }

    public void setResourceValueMatch(String resourceValueMatch) {
        this.resourceValueMatch = resourceValueMatch;
    }
}

