/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.monitor;

import com.hazelcast.impl.monitor.LocalOperationStatsSupport;
import com.hazelcast.monitor.LocalSemaphoreOperationStats;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LocalSemaphoreOperationStatsImpl
extends LocalOperationStatsSupport
implements LocalSemaphoreOperationStats {
    LocalOperationStatsSupport.OperationStat acquires = new LocalOperationStatsSupport.OperationStat(0L, 0L);
    LocalOperationStatsSupport.OperationStat nonAcquires = new LocalOperationStatsSupport.OperationStat(0L, 0L);
    long numberOfRejectedAcquires;
    long numberOfPermitsAcquired;
    long numberOfPermitsReleased;
    long numberOfPermitsAttached;
    long numberOfPermitsDetached;
    long numberOfPermitsReduced;

    void writeDataInternal(DataOutput out) throws IOException {
        this.acquires.writeData(out);
        this.nonAcquires.writeData(out);
        out.writeLong(this.numberOfRejectedAcquires);
        out.writeLong(this.numberOfPermitsAcquired);
        out.writeLong(this.numberOfPermitsReleased);
        out.writeLong(this.numberOfPermitsAttached);
        out.writeLong(this.numberOfPermitsDetached);
        out.writeLong(this.numberOfPermitsReduced);
    }

    void readDataInternal(DataInput in) throws IOException {
        this.acquires = new LocalOperationStatsSupport.OperationStat();
        this.acquires.readData(in);
        this.nonAcquires = new LocalOperationStatsSupport.OperationStat();
        this.nonAcquires.readData(in);
        this.numberOfRejectedAcquires = in.readLong();
        this.numberOfPermitsAcquired = in.readLong();
        this.numberOfPermitsReleased = in.readLong();
        this.numberOfPermitsAttached = in.readLong();
        this.numberOfPermitsDetached = in.readLong();
        this.numberOfPermitsReduced = in.readLong();
    }

    public long total() {
        return this.acquires.count + this.nonAcquires.count;
    }

    public long getNumberOfAcquireOps() {
        return this.acquires.count;
    }

    public long getNumberOfNonAcquireOps() {
        return this.nonAcquires.count;
    }

    public long getTotalAcquireLatency() {
        return this.acquires.totalLatency;
    }

    public long getTotalNonAcquireLatency() {
        return this.nonAcquires.totalLatency;
    }

    public long getNumberOfRejectedAcquires() {
        return this.numberOfRejectedAcquires;
    }

    public long getNumberOfPermitsAcquired() {
        return this.numberOfPermitsAcquired;
    }

    public long getNumberOfPermitsReduced() {
        return this.numberOfPermitsReduced;
    }

    public long getNumberOfPermitsReleased() {
        return this.numberOfPermitsReleased;
    }

    public long getNumberOfAttachedPermits() {
        return this.numberOfPermitsAttached;
    }

    public long getNumberOfDetachedPermits() {
        return this.numberOfPermitsDetached;
    }

    public String toString() {
        return "LocalSemaphoreOperationStats{total= " + this.total() + ", acquires total:" + this.acquires + ", acquires rejected:" + this.numberOfRejectedAcquires + ", non-acquires:" + this.nonAcquires + ", permits acquired: " + this.numberOfPermitsAcquired + ", permits released: " + this.numberOfPermitsReleased + ", permits attached: " + this.numberOfPermitsAttached + ", permits detached: " + this.numberOfPermitsDetached + ", permits reduced: " + this.numberOfPermitsReduced + "}";
    }
}

