/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.management;

import com.hazelcast.config.MapConfig;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.impl.CMap;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.management.ClusterServiceCallable;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetMapConfigCallable
extends ClusterServiceCallable
implements Callable<MapConfig>,
HazelcastInstanceAware,
DataSerializable {
    private static final long serialVersionUID = -3496139512682608428L;
    protected String mapName;

    public GetMapConfigCallable() {
    }

    public GetMapConfigCallable(String mapName) {
        this.mapName = mapName;
    }

    @Override
    public MapConfig call() throws Exception {
        final AtomicReference ref = new AtomicReference();
        this.getClusterService().enqueueAndWait(new Processable(){

            public void process() {
                CMap cmap = GetMapConfigCallable.this.getCMap(GetMapConfigCallable.this.mapName);
                MapConfig cfg = cmap.getRuntimeConfig();
                ref.set(cfg);
            }
        }, 5);
        return (MapConfig)ref.get();
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeUTF(this.mapName);
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.mapName = in.readUTF();
    }
}

