/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.web;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.query.DatasetAccessor;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import org.apache.jena.web.DatasetGraphAccessor;

public class DatasetAdapter
implements DatasetAccessor {
    private final DatasetGraphAccessor updater;

    public DatasetAdapter(DatasetGraphAccessor updater) {
        this.updater = updater;
    }

    @Override
    public Model getModel() {
        Graph g = this.updater.httpGet();
        return ModelFactory.createModelForGraph((Graph)g);
    }

    @Override
    public Model getModel(String graphUri) {
        Graph g = this.updater.httpGet(NodeFactory.createURI((String)graphUri));
        if (g == null) {
            return null;
        }
        return ModelFactory.createModelForGraph((Graph)g);
    }

    @Override
    public boolean containsModel(String graphUri) {
        return this.updater.httpHead(NodeFactory.createURI((String)graphUri));
    }

    @Override
    public void putModel(Model data) {
        this.updater.httpPut(data.getGraph());
    }

    @Override
    public void putModel(String graphUri, Model data) {
        this.updater.httpPut(NodeFactory.createURI((String)graphUri), data.getGraph());
    }

    @Override
    public void deleteDefault() {
        this.updater.httpDelete();
    }

    @Override
    public void deleteModel(String graphUri) {
        this.updater.httpDelete(NodeFactory.createURI((String)graphUri));
    }

    @Override
    public void add(Model data) {
        this.updater.httpPost(data.getGraph());
    }

    @Override
    public void add(String graphUri, Model data) {
        this.updater.httpPost(NodeFactory.createURI((String)graphUri), data.getGraph());
    }
}

