/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.web.auth;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.web.auth.AbstractScopedAuthenticator;

public class ScopedAuthenticator
extends AbstractScopedAuthenticator<Pair<String, char[]>> {
    private Map<URI, Pair<String, char[]>> credentials = new HashMap<URI, Pair<String, char[]>>();

    public ScopedAuthenticator(URI target, String username, char[] password) {
        if (target == null) {
            throw new IllegalArgumentException("Target URI cannot be null");
        }
        this.credentials.put(target, Pair.create(username, password));
    }

    public ScopedAuthenticator(Map<URI, Pair<String, char[]>> credentials) {
        this.credentials.putAll(credentials);
    }

    public void addCredentials(URI target, String username, char[] password) {
        if (target == null) {
            throw new IllegalArgumentException("Target URI cannot be null");
        }
        this.credentials.put(target, Pair.create(username, password));
    }

    @Override
    protected Pair<String, char[]> getCredentials(URI target) {
        return this.credentials.get(target);
    }

    @Override
    protected String getUserNameFromCredentials(Pair<String, char[]> credentials) {
        return credentials != null ? credentials.getLeft() : null;
    }

    @Override
    protected char[] getPasswordFromCredentials(Pair<String, char[]> credentials) {
        return credentials != null ? credentials.getRight() : null;
    }
}

