/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.base;

import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractInputStreamWrapper
extends InputStream {
    protected boolean closeCalled;
    protected final InputStream source;

    protected AbstractInputStreamWrapper(InputStream source) {
        if (source == null) {
            throw new IllegalArgumentException("InputStream source can't be null.");
        }
        this.source = source;
    }

    private void checkReadArguments(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException("Buffer for read(b,off,len) is null");
        }
        if (off < 0) {
            throw new IndexOutOfBoundsException("read(b,off,len) called with off < 0 ");
        }
        if (off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.closeCalled) {
            throw new IllegalStateException("Stream already closed");
        }
    }

    public void close() throws IOException {
        if (!this.closeCalled) {
            this.closeCalled = true;
            this.closeOnce();
        }
    }

    protected abstract void closeOnce() throws IOException;

    protected abstract int innerRead(byte[] var1, int var2, int var3) throws IOException;

    public int read() throws IOException {
        byte[] buf = new byte[1];
        int n = this.read(buf);
        int result = n > 0 ? buf[0] & 0xFF : n;
        return result;
    }

    public final int read(byte[] b, int off, int len) throws IOException {
        this.checkReadArguments(b, off, len);
        int result = 0;
        if (len > 0) {
            result = this.innerRead(b, off, len);
        }
        return result;
    }

    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException("Skip was called with a negative skip size[" + n + "]");
        }
        long curPos = 0L;
        int readLen = 0;
        byte[] buf = new byte[8192];
        while (curPos < n && readLen >= 0) {
            readLen = this.innerRead(buf, 0, (int)Math.min((long)buf.length, n - curPos));
            if (readLen <= 0) continue;
            curPos += (long)readLen;
        }
        return curPos;
    }
}

