/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.store;

import com.gc.iotools.stream.store.SeekableStore;
import java.io.IOException;

public class OnOffStore
implements SeekableStore {
    private boolean canEnable = true;
    private boolean enabled = true;
    private final SeekableStore store;

    public OnOffStore(SeekableStore store) {
        this.store = store;
    }

    public void cleanup() {
        this.store.cleanup();
    }

    public void enable(boolean enable) {
        if (enable != this.enabled) {
            if (enable && !this.canEnable) {
                throw new IllegalStateException("Enable was called but some data was already put on the buffer. Can't reenable.");
            }
            this.enabled = enable;
        }
    }

    public int get(byte[] bytes, int offset, int length) throws IOException {
        int num = this.store.get(bytes, offset, length);
        if (!this.enabled && num == 0) {
            this.cleanup();
        }
        return num;
    }

    public void put(byte[] bytes, int offset, int length) throws IOException {
        if (this.enabled) {
            this.store.put(bytes, offset, length);
        } else {
            this.canEnable = false;
        }
    }

    public void seek(long position) throws IOException {
        this.store.seek(position);
    }
}

