/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.evt;

import com.ctc.wstx.evt.WEvent;
import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.StartDocument;

public class WStartDocument
extends WEvent
implements StartDocument {
    private final boolean mStandaloneSet;
    private final boolean mIsStandalone;
    private final String mVersion;
    private final boolean mEncodingSet;
    private final String mEncodingScheme;
    private final String mSystemId;

    public WStartDocument(Location loc, XMLStreamReader r) {
        super(loc);
        this.mStandaloneSet = r.standaloneSet();
        this.mIsStandalone = r.isStandalone();
        String version = r.getVersion();
        if (version == null || version.length() == 0) {
            version = "1.0";
        }
        this.mVersion = version;
        this.mEncodingScheme = r.getCharacterEncodingScheme();
        this.mEncodingSet = this.mEncodingScheme != null && this.mEncodingScheme.length() > 0;
        this.mSystemId = loc != null ? loc.getSystemId() : "";
    }

    public WStartDocument(Location loc) {
        this(loc, (String)null);
    }

    public WStartDocument(Location loc, String encoding) {
        this(loc, encoding, null);
    }

    public WStartDocument(Location loc, String encoding, String version) {
        this(loc, encoding, version, false, false);
    }

    public WStartDocument(Location loc, String encoding, String version, boolean standaloneSet, boolean isStandalone) {
        super(loc);
        this.mEncodingScheme = encoding;
        this.mEncodingSet = encoding != null && encoding.length() > 0;
        this.mVersion = version;
        this.mStandaloneSet = standaloneSet;
        this.mIsStandalone = isStandalone;
        this.mSystemId = "";
    }

    public boolean encodingSet() {
        return this.mEncodingSet;
    }

    public String getCharacterEncodingScheme() {
        return this.mEncodingScheme;
    }

    public String getSystemId() {
        return this.mSystemId;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public boolean isStandalone() {
        return this.mIsStandalone;
    }

    public boolean standaloneSet() {
        return this.mStandaloneSet;
    }

    public int getEventType() {
        return 7;
    }

    public boolean isStartDocument() {
        return true;
    }

    public void writeAsEncodedUnicode(Writer w) throws XMLStreamException {
        try {
            w.write("<?xml version=\"");
            if (this.mVersion == null || this.mVersion.length() == 0) {
                w.write("1.0");
            } else {
                w.write(this.mVersion);
            }
            w.write(34);
            if (this.mEncodingSet) {
                w.write(" encoding=\"");
                w.write(this.mEncodingScheme);
                w.write(34);
            }
            if (this.mStandaloneSet) {
                if (this.mIsStandalone) {
                    w.write(" standalone=\"yes\"");
                } else {
                    w.write(" standalone=\"no\"");
                }
            }
            w.write(" ?>");
        }
        catch (IOException ie) {
            this.throwFromIOE(ie);
        }
    }

    public void writeUsing(XMLStreamWriter w) throws XMLStreamException {
        w.writeStartDocument();
    }
}

