/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.bookkeeper.jdbi;

import java.util.LinkedList;
import java.util.Map;
import org.dataone.bookkeeper.api.Order;
import org.dataone.bookkeeper.api.Quota;
import org.dataone.bookkeeper.jdbi.mappers.OrderMapper;
import org.jdbi.v3.core.result.LinkedHashMapRowReducer;
import org.jdbi.v3.core.result.RowView;
import org.jdbi.v3.sqlobject.config.RegisterBeanMapper;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;

@RegisterBeanMapper(value=Quota.class)
@RegisterRowMapper(value=OrderMapper.class)
public class OrderQuotasReducer
implements LinkedHashMapRowReducer<Integer, Order> {
    public void accumulate(Map<Integer, Order> map, RowView rowView) {
        Order order = map.computeIfAbsent((Integer)rowView.getColumn("o_id", Integer.class), id -> (Order)rowView.getRow(Order.class));
        if (rowView.getColumn("o_id", Integer.class) != null) {
            boolean hasQuotas;
            boolean bl = hasQuotas = rowView.getColumn("q_id", Integer.class) != null;
            if (hasQuotas && order.getQuotas() == null) {
                order.setQuotas(new LinkedList());
            }
            if (hasQuotas) {
                Quota quota = (Quota)rowView.getRow(Quota.class);
                order.getQuotas().add(quota);
            }
        }
    }
}

