/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.examples;

import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.Transaction;
import com.hazelcast.util.Clock;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LongRunningTransactionTest {
    private static final int STATS_SECONDS = 10;
    private List<TheNode> nodes = new CopyOnWriteArrayList<TheNode>();
    private int nodeIdGen = 0;
    private final Logger logger = Logger.getLogger(LongRunningTransactionTest.class.getName());
    private int starts;
    private int stops;
    private int restarts = 0;
    private final AtomicInteger ids = new AtomicInteger();
    private final Timer producer = new Timer();
    private final BlockingQueue<Integer> processedIds = new LinkedBlockingQueue<Integer>();
    private final Random random = new Random();

    public static void main(String[] args) {
        LongRunningTransactionTest t = new LongRunningTransactionTest();
        t.run();
    }

    public void run() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                LongRunningTransactionTest.this.log("Shutting down " + LongRunningTransactionTest.this.nodes.size());
                while (LongRunningTransactionTest.this.nodes.size() > 0) {
                    LongRunningTransactionTest.this.removeNode();
                }
            }
        });
        while (true) {
            if (this.nodes.size() > 4) {
                this.removeNode();
            } else if (this.nodes.size() == 0) {
                this.addNode();
                this.addNode();
                this.addNode();
                this.startIdProducer();
                this.startProcessWatcher();
            } else if (this.nodes.size() < 2) {
                this.addNode();
            } else {
                int action = this.random(3);
                switch (action) {
                    case 0: {
                        this.removeNode();
                        break;
                    }
                    case 1: {
                        this.addNode();
                        break;
                    }
                    case 2: {
                        this.restartNode();
                    }
                }
            }
            try {
                int nextSeconds = this.random(60, 260);
                this.log("Next Action after " + nextSeconds + " seconds.");
                this.log("members:" + this.nodes.size() + ", starts: " + this.starts + ", stops:" + this.stops + ", restart:" + this.restarts);
                this.log("transaction count: " + this.ids.get());
                Thread.sleep(nextSeconds * 1000);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private void startIdProducer() {
        this.producer.scheduleAtFixedRate(new TimerTask(){

            public void run() {
                IQueue<Integer> q = Hazelcast.getQueue("default");
                if (q.size() < 5000) {
                    for (int i = 0; i < 5000; ++i) {
                        q.offer(LongRunningTransactionTest.this.ids.incrementAndGet());
                    }
                }
            }
        }, 0L, 1000L);
    }

    private void startProcessWatcher() {
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            public void run() {
                TreeSet<Integer> outOfOrderIds = new TreeSet<Integer>();
                int lastId = 0;
                while (true) {
                    try {
                        block3: while (true) {
                            Integer id;
                            if ((id = (Integer)LongRunningTransactionTest.this.processedIds.take()) % 5000 == 0) {
                                LongRunningTransactionTest.this.log("ID " + id + "  mapSize " + Hazelcast.getMap("default").size() + " OO " + outOfOrderIds.size() + ", lastId:" + lastId);
                            }
                            if (id == lastId + 1) {
                                lastId = id;
                                if (outOfOrderIds.size() <= 0) continue;
                                if (outOfOrderIds.size() > 20) {
                                    LongRunningTransactionTest.this.log("Consuming outOfOrders " + outOfOrderIds.size());
                                }
                                if (outOfOrderIds.size() > 1000) {
                                    Thread.sleep(1000L);
                                    System.exit(0);
                                }
                                TreeSet<Integer> outOfOrderIdsNow = outOfOrderIds;
                                outOfOrderIds = new TreeSet();
                                Iterator i$ = outOfOrderIdsNow.iterator();
                                while (true) {
                                    if (!i$.hasNext()) continue block3;
                                    Integer idOutOfOrder = (Integer)i$.next();
                                    if (idOutOfOrder == lastId + 1) {
                                        lastId = idOutOfOrder;
                                        continue;
                                    }
                                    outOfOrderIds.add(idOutOfOrder);
                                }
                            }
                            outOfOrderIds.add(id);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        });
    }

    void log(Object obj) {
        this.logger.log(Level.INFO, "LRT-" + obj);
    }

    void addNode() {
        ++this.starts;
        int entryCount = this.random(10000);
        int threadCount = this.random(10, 50);
        TheNode node = new TheNode(this.nodeIdGen++, entryCount, threadCount);
        this.nodes.add(node);
        node.start();
        this.log("Started " + node);
    }

    void restartNode() {
        ++this.restarts;
        this.log("Restarting...");
        this.removeNode();
        try {
            Thread.sleep(this.random(10) * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.addNode();
    }

    void removeNode() {
        ++this.stops;
        TheNode node = this.nodes.remove(this.random(this.nodes.size()));
        node.stop();
        this.log("Stopped " + node);
    }

    int random(int length) {
        return (int)(Math.random() * 1.0E7) % length;
    }

    int random(int from, int to) {
        double diff = to - from;
        return (int)(diff * Math.random() + (double)from);
    }

    class Stats {
        public AtomicLong mapPuts = new AtomicLong();
        public AtomicLong mapTakes = new AtomicLong();

        Stats() {
        }

        public Stats getAndReset() {
            long mapPutsNow = this.mapPuts.getAndSet(0L);
            long mapRemovesNow = this.mapTakes.getAndSet(0L);
            Stats newOne = new Stats();
            newOne.mapPuts.set(mapPutsNow);
            newOne.mapTakes.set(mapRemovesNow);
            return newOne;
        }

        public long total() {
            return this.mapPuts.get() + this.mapTakes.get();
        }

        public String toString() {
            return "total= " + this.total() + ", puts:" + this.mapPuts.get() + ", remove:" + this.mapTakes.get();
        }
    }

    class TheNode {
        final int entryCount;
        final int threadCount;
        final int nodeId;
        final long createTime;
        final ExecutorService es;
        final ExecutorService esStats;
        final HazelcastInstance hazelcast;
        volatile boolean running = true;

        TheNode(int nodeId, int entryCount, int threadCount) {
            this.entryCount = entryCount;
            this.threadCount = threadCount;
            this.nodeId = nodeId;
            this.es = Executors.newFixedThreadPool(threadCount);
            this.hazelcast = Hazelcast.newHazelcastInstance(new Config());
            this.esStats = Executors.newSingleThreadExecutor();
            this.createTime = Clock.currentTimeMillis();
        }

        public void stop() {
            try {
                this.running = false;
                this.es.shutdown();
                this.es.awaitTermination(10L, TimeUnit.SECONDS);
                this.esStats.shutdown();
                this.hazelcast.shutdown();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        public void start() {
            final Stats stats = new Stats();
            for (int i = 0; i < this.threadCount; ++i) {
                this.es.execute(new Runnable(){

                    public void run() {
                        IQueue q = TheNode.this.hazelcast.getQueue("default");
                        IMap<Integer, Integer> map1 = TheNode.this.hazelcast.getMap("default");
                        IMap<Integer, Integer> map2 = TheNode.this.hazelcast.getMap("default");
                        IMap<Integer, Integer> map3 = TheNode.this.hazelcast.getMap("default");
                        IMap<Integer, Integer> map4 = TheNode.this.hazelcast.getMap("default");
                        while (TheNode.this.running) {
                            try {
                                Transaction txn = TheNode.this.hazelcast.getTransaction();
                                txn.begin();
                                try {
                                    int key = LongRunningTransactionTest.this.random(1000);
                                    while (key < 5) {
                                        key = LongRunningTransactionTest.this.random(1000);
                                    }
                                    Integer id = (Integer)q.take();
                                    Integer id1 = map1.put(1, id);
                                    Integer id2 = map2.put(2, id);
                                    Integer id3 = map3.put(3, id);
                                    Integer id4 = map4.put(key, id);
                                    Thread.sleep(LongRunningTransactionTest.this.random.nextInt(5));
                                    txn.commit();
                                    LongRunningTransactionTest.this.processedIds.put(id);
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                    txn.rollback();
                                }
                            }
                            catch (Throwable ignored) {}
                        }
                    }
                });
            }
            this.esStats.execute(new Runnable(){

                public void run() {
                    while (TheNode.this.running) {
                        try {
                            Thread.sleep(10000L);
                            int clusterSize = TheNode.this.hazelcast.getCluster().getMembers().size();
                            Stats currentStats = stats.getAndReset();
                            LongRunningTransactionTest.this.log("Cluster size: " + clusterSize + ", Operations per Second: " + currentStats.total() / 10L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }

        public String toString() {
            return "TheNode [" + this.nodeId + "] entryCount=" + this.entryCount + ", threadCount=" + this.threadCount + ", liveSeconds=" + (Clock.currentTimeMillis() - this.createTime) / 1000L + ", running=" + this.running + '}';
        }
    }
}

