/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.speedbagit;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.dataone.speedbagit.SpeedFile;
import org.dataone.speedbagit.SpeedStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SpeedFileTest {
    @Test
    public void testGetPath() {
        String testCsvFile = "1234, 56789";
        String targetPath = "data/my_csv_file.csv";
        ByteArrayInputStream fileStream = new ByteArrayInputStream(testCsvFile.getBytes(StandardCharsets.UTF_8));
        try {
            SpeedStream speedStream = new SpeedStream((InputStream)fileStream, MessageDigest.getInstance("MD5"));
            SpeedFile testFile = new SpeedFile(speedStream, targetPath, false);
            String path = testFile.getPath();
            Assertions.assertEquals((Object)path, (Object)targetPath);
        }
        catch (NoSuchAlgorithmException e) {
            Assertions.fail();
        }
    }

    @Test
    public void testGetStream() {
        String testCsvFile = "1234, 56789";
        String targetPath = "data/my_csv_file.csv";
        ByteArrayInputStream fileStream = new ByteArrayInputStream(testCsvFile.getBytes(StandardCharsets.UTF_8));
        try {
            SpeedStream speedStream = new SpeedStream((InputStream)fileStream, MessageDigest.getInstance("MD5"));
            SpeedFile testFile = new SpeedFile(speedStream, targetPath, false);
            SpeedStream stream = testFile.getStream();
            Assertions.assertEquals((Object)stream, (Object)speedStream);
        }
        catch (NoSuchAlgorithmException e) {
            Assertions.fail();
        }
    }

    @Test
    public void testIsTagFile() {
        String testCsvFile = "1234, 56789";
        String targetPath = "data/my_csv_file.csv";
        boolean tagFile = false;
        ByteArrayInputStream fileStream = new ByteArrayInputStream(testCsvFile.getBytes(StandardCharsets.UTF_8));
        try {
            SpeedStream speedStream = new SpeedStream((InputStream)fileStream, MessageDigest.getInstance("MD5"));
            SpeedFile testFile = new SpeedFile(speedStream, targetPath, tagFile);
            boolean isTag = testFile.isTagFile();
            Assertions.assertEquals((Object)isTag, (Object)tagFile);
        }
        catch (NoSuchAlgorithmException e) {
            Assertions.fail();
        }
    }
}

