/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.graph.ALink;
import net.sourceforge.plantuml.graph.ALinkImpl;
import net.sourceforge.plantuml.graph.ANode;
import net.sourceforge.plantuml.graph.ANodeImpl;
import net.sourceforge.plantuml.graph.LinkString;

public class Heap {
    private final Map<String, ANode> nodes = new LinkedHashMap<String, ANode>();
    private final Map<ANode, LinkedHashMap<ANode, ALink>> directChildren = new LinkedHashMap<ANode, LinkedHashMap<ANode, ALink>>();
    private final List<ALink> links = new ArrayList<ALink>();

    public boolean isEmpty() {
        if (this.links.isEmpty()) {
            assert (this.nodes.isEmpty());
            assert (this.directChildren.isEmpty());
            return true;
        }
        return false;
    }

    public void importing(ANode under, ANode otherRoot, Heap otherHeap, int diffHeight, Object userData) {
        assert (this.directChildren.keySet().contains(under));
        assert (this.nodes.values().contains(under));
        assert (otherHeap.nodes.values().contains(otherRoot));
        assert (otherHeap.directChildren.keySet().contains(otherRoot));
        assert (!this.nodes.values().contains(otherRoot));
        assert (!this.directChildren.keySet().contains(otherRoot));
        assert (!otherHeap.directChildren.keySet().contains(under));
        int oldSize = this.nodes.size();
        assert (oldSize == this.directChildren.size());
        this.nodes.putAll(otherHeap.nodes);
        this.directChildren.putAll(otherHeap.directChildren);
        ALinkImpl link = new ALinkImpl(under, otherRoot, diffHeight, userData);
        this.links.add(link);
        this.links.addAll(otherHeap.links);
        assert (oldSize + otherHeap.nodes.size() == this.nodes.size());
        assert (oldSize + otherHeap.directChildren.size() == this.directChildren.size());
        this.addUnderMe(under, otherRoot, link);
    }

    public void computeRows() {
        boolean changed;
        for (ANode n : this.nodes.values()) {
            n.setRow(Integer.MIN_VALUE);
        }
        this.nodes.values().iterator().next().setRow(0);
        do {
            this.onePass();
            changed = false;
            for (ANode n : this.nodes.values()) {
                if (n.getRow() != Integer.MIN_VALUE) continue;
                Map.Entry<ANode, ALink> smallestRowOfChildren = this.getSmallestRowOfChildren(n);
                if (smallestRowOfChildren != null) {
                    n.setRow(this.getStartingRow(smallestRowOfChildren));
                }
                changed = true;
            }
        } while (changed);
        this.minToZero();
    }

    private int getStartingRow(Map.Entry<ANode, ALink> ent) {
        assert (ent.getValue().getNode2() == ent.getKey());
        return ent.getValue().getNode2().getRow() - ent.getValue().getDiffHeight();
    }

    private void minToZero() {
        int min = Integer.MAX_VALUE;
        for (ANode n : this.nodes.values()) {
            min = Math.min(min, n.getRow());
        }
        if (min == Integer.MIN_VALUE) {
            throw new IllegalStateException();
        }
        if (min != 0) {
            for (ANode n : this.nodes.values()) {
                n.setRow(n.getRow() - min);
            }
        }
    }

    private Map.Entry<ANode, ALink> getSmallestRowOfChildren(ANode n) {
        assert (n.getRow() == Integer.MIN_VALUE);
        Map.Entry<ANode, ALink> result = null;
        for (Map.Entry<ANode, ALink> ent : this.directChildren.get(n).entrySet()) {
            ANode child = ent.getKey();
            if (child.getRow() == Integer.MIN_VALUE || result != null && this.getStartingRow(ent) >= this.getStartingRow(result)) continue;
            result = ent;
        }
        return result;
    }

    private void onePass() {
        boolean changed;
        do {
            changed = false;
            for (ANode n : this.nodes.values()) {
                int row = n.getRow();
                if (row == Integer.MIN_VALUE) continue;
                for (Map.Entry<ANode, ALink> ent : this.directChildren.get(n).entrySet()) {
                    ANode child = ent.getKey();
                    int diffHeight = ent.getValue().getDiffHeight();
                    if (child.getRow() != Integer.MIN_VALUE && child.getRow() >= row + diffHeight) continue;
                    child.setRow(row + diffHeight);
                    changed = true;
                }
            }
        } while (changed);
    }

    private ANode getNode(String code) {
        ANode result = this.nodes.get(code);
        if (result == null) {
            result = this.createNewNode(code);
        }
        return result;
    }

    private ANode createNewNode(String code) {
        ANodeImpl result = new ANodeImpl(code);
        this.directChildren.put(result, new LinkedHashMap());
        this.nodes.put(code, result);
        assert (this.directChildren.size() == this.nodes.size());
        return result;
    }

    public ANode getExistingNode(String code) {
        return this.nodes.get(code);
    }

    public List<ALink> getLinks() {
        return Collections.unmodifiableList(this.links);
    }

    public List<ANode> getNodes() {
        return Collections.unmodifiableList(new ArrayList<ANode>(this.nodes.values()));
    }

    HashSet<ANode> getAllChildren(ANode n) {
        HashSet<ANode> result = new HashSet<ANode>(this.directChildren.get(n).keySet());
        int size = 0;
        do {
            size = result.size();
            for (ANode other : new HashSet<ANode>(result)) {
                result.addAll(this.getAllChildren(other));
            }
        } while (result.size() != size);
        return result;
    }

    public void addLink(String stringLink, int diffHeight, Object userData) {
        ANode n2;
        LinkString l = new LinkString(stringLink);
        ANode n1 = this.getNode(l.getNode1());
        if (n1 == (n2 = this.getNode(l.getNode2()))) {
            return;
        }
        ALinkImpl link = new ALinkImpl(n1, n2, diffHeight, userData);
        this.links.add(link);
        if (this.getAllChildren(n2).contains(n1)) {
            this.addUnderMe(n2, n1, link);
        } else {
            this.addUnderMe(n1, n2, link);
        }
    }

    public ANode addNode(String code) {
        if (this.nodes.containsKey(code)) {
            throw new IllegalArgumentException();
        }
        return this.createNewNode(code);
    }

    private void addUnderMe(ANode n1, ANode n2, ALinkImpl link) {
        assert (!this.getAllChildren(n2).contains(n1));
        this.directChildren.get(n1).put(n2, link);
        assert (this.getAllChildren(n1).contains(n2));
        assert (!this.getAllChildren(n2).contains(n1));
    }

    public int getRowMax() {
        int max = Integer.MIN_VALUE;
        for (ANode n : this.nodes.values()) {
            max = Math.max(max, n.getRow());
        }
        return max;
    }
}

