/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project2;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.project2.Day;
import net.sourceforge.plantuml.project2.Task;
import net.sourceforge.plantuml.project2.TaskAttribute;
import net.sourceforge.plantuml.project2.TaskContainer;
import net.sourceforge.plantuml.project2.TimeElement;
import net.sourceforge.plantuml.project2.TimeLine;
import net.sourceforge.plantuml.project2.Value;
import net.sourceforge.plantuml.project2.ValueInt;
import net.sourceforge.plantuml.project2.ValueTime;

public class Knowledge {
    private final TaskContainer taskContainer;
    private final TimeLine timeline;
    private final Map<String, Value> variables = new HashMap<String, Value>();

    public Knowledge(TaskContainer taskContainer, TimeLine timeline) {
        this.taskContainer = taskContainer;
        this.timeline = timeline;
    }

    public Value evaluate(String exp) {
        int idx = (exp = StringUtils.trin(exp)).indexOf(36);
        if (idx != -1) {
            return this.evaluate(exp.substring(0, idx), exp.substring(idx + 1));
        }
        if (exp.matches("\\d+")) {
            return new ValueInt(Integer.parseInt(exp));
        }
        if (Day.isValidDesc(exp)) {
            Day day = new Day(exp);
            return new ValueTime(day);
        }
        if (exp.startsWith("^")) {
            exp = exp.substring(1);
        }
        if (this.variables.containsKey(exp)) {
            return this.variables.get(exp);
        }
        idx = exp.indexOf("+");
        if (idx != -1) {
            return this.plus(exp.substring(0, idx), exp.substring(idx + 1));
        }
        throw new UnsupportedOperationException(exp);
    }

    private Value plus(String arg1, String arg2) {
        Value v1 = this.evaluate(arg1);
        Value v2 = this.evaluate(arg2);
        if (v1 instanceof ValueInt && v2 instanceof ValueInt) {
            return new ValueInt(((ValueInt)v1).getValue() + ((ValueInt)v2).getValue());
        }
        if (v1 instanceof ValueTime && v2 instanceof ValueInt) {
            int i;
            int nb = ((ValueInt)v2).getValue();
            TimeElement t = ((ValueTime)v1).getValue();
            if (nb > 0) {
                for (i = 0; i < nb; ++i) {
                    t = this.timeline.next(t);
                }
            }
            if (nb < 0) {
                for (i = 0; i < -nb; ++i) {
                    t = this.timeline.previous(t);
                }
            }
            return new ValueTime(t);
        }
        throw new UnsupportedOperationException();
    }

    private Value evaluate(String task, String attribute) {
        Task t = this.taskContainer.getTask(task);
        TaskAttribute att = TaskAttribute.fromString(attribute);
        if (att == TaskAttribute.COMPLETED) {
            return new ValueTime(t.getCompleted());
        }
        throw new UnsupportedOperationException();
    }

    public void set(String var, Value exp) {
        this.variables.put(var, exp);
    }
}

