/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import net.sourceforge.plantuml.SkinParamBackcolored;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.InGroupable;
import net.sourceforge.plantuml.sequencediagram.MessageExo;
import net.sourceforge.plantuml.sequencediagram.MessageExoType;
import net.sourceforge.plantuml.sequencediagram.graphic.Arrow;
import net.sourceforge.plantuml.sequencediagram.graphic.ArrowAndNoteBox;
import net.sourceforge.plantuml.sequencediagram.graphic.ConstraintSet;
import net.sourceforge.plantuml.sequencediagram.graphic.DrawableSet;
import net.sourceforge.plantuml.sequencediagram.graphic.Frontier;
import net.sourceforge.plantuml.sequencediagram.graphic.InGroupablesStack;
import net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import net.sourceforge.plantuml.sequencediagram.graphic.MessageExoArrow;
import net.sourceforge.plantuml.sequencediagram.graphic.NoteBox;
import net.sourceforge.plantuml.sequencediagram.graphic.ParticipantRange;
import net.sourceforge.plantuml.sequencediagram.graphic.Step1Abstract;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ComponentType;

class Step1MessageExo
extends Step1Abstract {
    private final MessageExoArrow messageArrow;

    Step1MessageExo(ParticipantRange range, StringBounder stringBounder, MessageExo message, DrawableSet drawingSet, Frontier freeY) {
        super(range, stringBounder, message, drawingSet, freeY);
        this.setConfig(this.getArrowType(message));
        this.messageArrow = new MessageExoArrow(freeY.getFreeY(range), drawingSet.getSkin(), drawingSet.getSkin().createComponent(ComponentType.ARROW, this.getConfig(), drawingSet.getSkinParam(), message.getLabelNumbered()), this.getLivingParticipantBox(), message.getType(), message.getUrl(), message.isShortArrow(), message.getArrowConfiguration());
        if (message.getNote() != null) {
            SkinParamBackcolored skinParam = message.getSkinParamNoteBackcolored(drawingSet.getSkinParam());
            this.setNote(drawingSet.getSkin().createComponent(ComponentType.NOTE, null, skinParam, message.getNote()));
        }
    }

    @Override
    Frontier prepareMessage(ConstraintSet constraintSet, InGroupablesStack inGroupablesStack) {
        Arrow graphic = this.createArrow();
        double arrowYStartLevel = graphic.getArrowYStartLevel(this.getStringBounder());
        double arrowYEndLevel = graphic.getArrowYEndLevel(this.getStringBounder());
        this.getMessage().setPosYstartLevel(arrowYStartLevel);
        double length = graphic.getArrowOnlyWidth(this.getStringBounder());
        this.incFreeY(graphic.getPreferredHeight(this.getStringBounder()));
        double marginActivateAndDeactive = 0.0;
        if (this.getMessage().isActivateAndDeactive()) {
            marginActivateAndDeactive = 30.0;
            this.incFreeY(marginActivateAndDeactive);
        }
        this.getDrawingSet().addEvent(this.getMessage(), graphic);
        LivingParticipantBox livingParticipantBox = this.getLivingParticipantBox();
        if (this.messageArrow.getType().isRightBorder()) {
            constraintSet.getConstraint(livingParticipantBox.getParticipantBox(), constraintSet.getLastborder()).ensureValue(length);
        } else {
            constraintSet.getConstraint(constraintSet.getFirstBorder(), livingParticipantBox.getParticipantBox()).ensureValue(length);
        }
        double posYendLevel = arrowYEndLevel + marginActivateAndDeactive;
        this.getMessage().setPosYendLevel(posYendLevel);
        assert (graphic instanceof InGroupable);
        if (graphic instanceof InGroupable) {
            inGroupablesStack.addElement(graphic);
            inGroupablesStack.addElement(livingParticipantBox);
        }
        return this.getFreeY();
    }

    private LivingParticipantBox getLivingParticipantBox() {
        return this.getDrawingSet().getLivingParticipantBox(((MessageExo)this.getMessage()).getParticipant());
    }

    private Arrow createArrow() {
        if (this.getMessage().getNote() == null) {
            return this.messageArrow;
        }
        NoteBox toto = this.createNoteBox(this.getStringBounder(), this.messageArrow, this.getNote(), this.getMessage().getNotePosition(), this.getMessage().getUrlNote());
        return new ArrowAndNoteBox(this.getStringBounder(), this.messageArrow, toto);
    }

    private ArrowConfiguration getArrowType(MessageExo m) {
        MessageExoType type = m.getType();
        ArrowConfiguration result = null;
        result = type.getDirection() == 1 ? m.getArrowConfiguration() : m.getArrowConfiguration().reverse();
        result = result.withDecoration1(m.getArrowConfiguration().getDecoration1());
        result = result.withDecoration2(m.getArrowConfiguration().getDecoration2());
        return result;
    }
}

