/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.geom.Point2D;

public enum Direction {
    RIGHT,
    LEFT,
    DOWN,
    UP;


    public Direction getInv() {
        if (this == RIGHT) {
            return LEFT;
        }
        if (this == LEFT) {
            return RIGHT;
        }
        if (this == DOWN) {
            return UP;
        }
        if (this == UP) {
            return DOWN;
        }
        throw new IllegalStateException();
    }

    public static Direction fromChar(char c) {
        if (c == '<') {
            return LEFT;
        }
        if (c == '>') {
            return RIGHT;
        }
        if (c == '^') {
            return UP;
        }
        return DOWN;
    }

    public Direction clockwise() {
        if (this == RIGHT) {
            return DOWN;
        }
        if (this == LEFT) {
            return UP;
        }
        if (this == DOWN) {
            return LEFT;
        }
        if (this == UP) {
            return RIGHT;
        }
        throw new IllegalStateException();
    }

    public static Direction leftOrRight(Point2D p1, Point2D p2) {
        if (p1.getX() < p2.getX()) {
            return LEFT;
        }
        if (p1.getX() > p2.getX()) {
            return RIGHT;
        }
        throw new IllegalArgumentException();
    }

    public static Direction fromVector(Point2D p1, Point2D p2) {
        double x1 = p1.getX();
        double y1 = p1.getY();
        double x2 = p2.getX();
        double y2 = p2.getY();
        if (x1 == x2 && y1 == y2) {
            return null;
        }
        if (x1 == x2) {
            if (y2 > y1) {
                return DOWN;
            }
            return UP;
        }
        if (y1 == y2) {
            if (x2 > x1) {
                return RIGHT;
            }
            return LEFT;
        }
        throw new IllegalArgumentException("Not a H or V line!");
    }
}

