/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionList;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.NotePosition;

public class InstructionRepeat
implements Instruction {
    private final InstructionList repeatList = new InstructionList();
    private final Instruction parent;
    private final LinkRendering nextLinkRenderer;
    private final Swimlane swimlane;
    private final HtmlColor color;
    private Display test = Display.NULL;
    private Display yes = Display.NULL;
    private Display out = Display.NULL;
    private LinkRendering endRepeatLinkRendering;
    private LinkRendering backRepeatLinkRendering;

    public InstructionRepeat(Swimlane swimlane, Instruction parent, LinkRendering nextLinkRenderer, HtmlColor color) {
        this.parent = parent;
        this.swimlane = swimlane;
        this.nextLinkRenderer = nextLinkRenderer;
        this.color = color;
    }

    @Override
    public void add(Instruction ins) {
        this.repeatList.add(ins);
    }

    @Override
    public Ftile createFtile(FtileFactory factory) {
        return factory.repeat(this.swimlane, factory.decorateOut(this.repeatList.createFtile(factory), this.endRepeatLinkRendering), this.test, this.yes, this.out, this.color, this.backRepeatLinkRendering);
    }

    public Instruction getParent() {
        return this.parent;
    }

    public void setTest(Display test, Display yes, Display out, LinkRendering endRepeatLinkRendering, LinkRendering backRepeatLinkRendering) {
        this.test = test;
        this.yes = yes;
        this.out = out;
        if (test == null) {
            throw new IllegalArgumentException();
        }
        if (yes == null) {
            throw new IllegalArgumentException();
        }
        if (out == null) {
            throw new IllegalArgumentException();
        }
        this.endRepeatLinkRendering = endRepeatLinkRendering;
        this.backRepeatLinkRendering = backRepeatLinkRendering;
    }

    @Override
    public final boolean kill() {
        return this.repeatList.kill();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.nextLinkRenderer;
    }

    @Override
    public boolean addNote(Display note, NotePosition position) {
        return this.repeatList.addNote(note, position);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.repeatList.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.parent.getSwimlaneOut();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.repeatList.getSwimlaneOut();
    }
}

