/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.hector;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.CucaDiagramFileMaker;
import net.sourceforge.plantuml.svek.CucaDiagramFileMakerSvek2;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphic2;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class CucaDiagramFileMakerHector
implements CucaDiagramFileMaker {
    private final CucaDiagram diagram;
    private final Map<ILeaf, IEntityImage> images = new LinkedHashMap<ILeaf, IEntityImage>();

    public CucaDiagramFileMakerHector(CucaDiagram diagram) {
        this.diagram = diagram;
    }

    @Override
    public ImageData createFile(OutputStream os, List<String> dotStrings, FileFormatOption fileFormatOption) throws IOException {
        double singleWidth = 0.0;
        double singleHeight = 0.0;
        int nb = 0;
        for (ILeaf leaf : this.diagram.getLeafsvalues()) {
            IEntityImage image = this.computeImage(leaf);
            Dimension2D dim = TextBlockUtils.getDimension(image);
            if (dim.getWidth() > singleWidth) {
                singleWidth = dim.getWidth();
            }
            if (dim.getHeight() > singleHeight) {
                singleHeight = dim.getHeight();
            }
            this.images.put(leaf, image);
            ++nb;
        }
        double margin = 10.0;
        Dimension2DDouble dim = new Dimension2DDouble(20.0 + (double)nb * singleWidth, singleHeight + 20.0);
        UGraphic ug = null;
        ug = (UGraphic2)ug.apply(new UTranslate(10.0, 10.0));
        double pos = 0.0;
        for (IEntityImage im : this.images.values()) {
            im.drawU(ug.apply(new UTranslate(pos, 0.0)));
            pos += singleWidth;
        }
        throw new UnsupportedOperationException();
    }

    private IEntityImage computeImage(ILeaf leaf) {
        IEntityImage image = CucaDiagramFileMakerSvek2.createEntityImageBlock(leaf, this.diagram.getSkinParam(), false, this.diagram, null, null, null);
        return image;
    }
}

