/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.objectdiagram;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.utils.UniqueSequence;

public abstract class AbstractClassOrObjectDiagram
extends AbstractEntityDiagram {
    private final List<Association> assocations = new ArrayList<Association>();

    public final boolean insertBetween(IEntity entity1, IEntity entity2, IEntity node) {
        Link link = this.foundLink(entity1, entity2);
        if (link == null) {
            return false;
        }
        Link l1 = new Link(entity1, node, link.getType(), link.getLabel(), link.getLength(), link.getQualifier1(), null, link.getLabeldistance(), link.getLabelangle());
        Link l2 = new Link(node, entity2, link.getType(), link.getLabel(), link.getLength(), null, link.getQualifier2(), link.getLabeldistance(), link.getLabelangle());
        this.addLink(l1);
        this.addLink(l2);
        this.removeLink(link);
        return true;
    }

    private Link foundLink(IEntity entity1, IEntity entity2) {
        List<Link> links = this.getLinks();
        for (int i = links.size() - 1; i >= 0; --i) {
            Link l = links.get(i);
            if (!l.isBetween(entity1, entity2)) continue;
            return l;
        }
        return null;
    }

    public int getNbOfHozizontalLollipop(IEntity entity) {
        if (entity.getEntityType() == LeafType.LOLLIPOP) {
            throw new IllegalArgumentException();
        }
        int result = 0;
        for (Link link : this.getLinks()) {
            if (link.getLength() != 1 || !link.contains(entity) || !link.containsType(LeafType.LOLLIPOP)) continue;
            ++result;
        }
        return result;
    }

    public boolean associationClass(int mode, Code clName1, Code clName2, IEntity associed, LinkType linkType, Display label) {
        Association association;
        IEntity entity1 = this.getOrCreateLeaf(clName1, null, null);
        IEntity entity2 = this.getOrCreateLeaf(clName2, null, null);
        ArrayList<Association> same = new ArrayList<Association>();
        for (Association existing : this.assocations) {
            if (!existing.sameCouple(entity1, entity2)) continue;
            same.add(existing);
        }
        if (same.size() > 1) {
            return false;
        }
        if (same.size() == 0) {
            association = new Association(mode, entity1, entity2, associed);
            association.createNew(mode, linkType, label);
            this.assocations.add(association);
            return true;
        }
        assert (same.size() == 1);
        association = ((Association)same.get(0)).createSecondAssociation(mode, associed, label);
        association.createInSecond(linkType, label);
        this.assocations.add(association);
        return true;
    }

    class Association {
        private IEntity entity1;
        private IEntity entity2;
        private IEntity associed;
        private IEntity point;
        private Link existingLink;
        private Link entity1ToPoint;
        private Link pointToEntity2;
        private Link pointToAssocied;
        private Association other;

        public Association(int mode, IEntity entity1, IEntity entity2, IEntity associed) {
            this.entity1 = entity1;
            this.entity2 = entity2;
            this.associed = associed;
            this.point = AbstractClassOrObjectDiagram.this.getOrCreateLeaf(UniqueSequence.getCode("apoint"), LeafType.POINT_FOR_ASSOCIATION, null);
        }

        public Association createSecondAssociation(int mode2, IEntity associed2, Display label) {
            Association result = new Association(mode2, this.entity1, this.entity2, associed2);
            result.existingLink = this.existingLink;
            result.other = this;
            if (this.existingLink.getLength() == 1) {
                this.entity1ToPoint.setLength(2);
                this.pointToEntity2.setLength(2);
                this.pointToAssocied.setLength(1);
            }
            return result;
        }

        void createNew(int mode, LinkType linkType, Display label) {
            this.existingLink = AbstractClassOrObjectDiagram.this.foundLink(this.entity1, this.entity2);
            if (this.existingLink == null) {
                this.existingLink = new Link(this.entity1, this.entity2, new LinkType(LinkDecor.NONE, LinkDecor.NONE), Display.NULL, 2);
            } else {
                AbstractClassOrObjectDiagram.this.removeLink(this.existingLink);
            }
            this.entity1ToPoint = new Link(this.entity1, this.point, this.existingLink.getType().getPart2(), this.existingLink.getLabel(), this.existingLink.getLength(), this.existingLink.getQualifier1(), null, this.existingLink.getLabeldistance(), this.existingLink.getLabelangle());
            this.entity1ToPoint.setLinkArrow(this.existingLink.getLinkArrow());
            this.pointToEntity2 = new Link(this.point, this.entity2, this.existingLink.getType().getPart1(), Display.NULL, this.existingLink.getLength(), null, this.existingLink.getQualifier2(), this.existingLink.getLabeldistance(), this.existingLink.getLabelangle());
            AbstractClassOrObjectDiagram.this.addLink(this.entity1ToPoint);
            AbstractClassOrObjectDiagram.this.addLink(this.pointToEntity2);
            int length = 1;
            if (this.existingLink.getLength() == 1 && this.entity1 != this.entity2) {
                length = 2;
            }
            if (this.existingLink.getLength() == 2 && this.entity1 == this.entity2) {
                length = 2;
            }
            this.pointToAssocied = mode == 1 ? new Link(this.point, this.associed, linkType, label, length) : new Link(this.associed, this.point, linkType, label, length);
            AbstractClassOrObjectDiagram.this.addLink(this.pointToAssocied);
        }

        void createInSecond(LinkType linkType, Display label) {
            this.existingLink = AbstractClassOrObjectDiagram.this.foundLink(this.entity1, this.entity2);
            if (this.existingLink == null) {
                this.existingLink = new Link(this.entity1, this.entity2, new LinkType(LinkDecor.NONE, LinkDecor.NONE), Display.NULL, 2);
            } else {
                AbstractClassOrObjectDiagram.this.removeLink(this.existingLink);
            }
            this.entity1ToPoint = new Link(this.entity1, this.point, this.existingLink.getType().getPart2(), this.existingLink.getLabel(), 2, this.existingLink.getQualifier1(), null, this.existingLink.getLabeldistance(), this.existingLink.getLabelangle());
            this.pointToEntity2 = new Link(this.point, this.entity2, this.existingLink.getType().getPart1(), Display.NULL, 2, null, this.existingLink.getQualifier2(), this.existingLink.getLabeldistance(), this.existingLink.getLabelangle());
            AbstractClassOrObjectDiagram.this.addLink(this.entity1ToPoint);
            AbstractClassOrObjectDiagram.this.addLink(this.pointToEntity2);
            if (this.other.pointToAssocied.getEntity1().getEntityType() == LeafType.POINT_FOR_ASSOCIATION) {
                AbstractClassOrObjectDiagram.this.removeLink(this.other.pointToAssocied);
                this.other.pointToAssocied = this.other.pointToAssocied.getInv();
                AbstractClassOrObjectDiagram.this.addLink(this.other.pointToAssocied);
            }
            this.pointToAssocied = new Link(this.point, this.associed, linkType, label, 1);
            AbstractClassOrObjectDiagram.this.addLink(this.pointToAssocied);
            Link lnode = new Link(this.other.point, this.point, new LinkType(LinkDecor.NONE, LinkDecor.NONE), Display.NULL, 1);
            lnode.setInvis(true);
            AbstractClassOrObjectDiagram.this.addLink(lnode);
        }

        boolean sameCouple(IEntity entity1, IEntity entity2) {
            if (this.entity1 == entity1 && this.entity2 == entity2) {
                return true;
            }
            return this.entity1 == entity2 && this.entity2 == entity1;
        }
    }
}

